/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractSetPointCommandShortFloatingPoint;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.ValueCommandMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CommandValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;

@ASDU(id=50, name="C_SE_NC_1", informationStructure=InformationStructure.SINGLE)
public class SetPointCommandShortFloatingPoint
extends AbstractSetPointCommandShortFloatingPoint
implements ValueCommandMessage {
    public SetPointCommandShortFloatingPoint(ASDUHeader header, InformationObjectAddress informationObjectAddress, float value, byte type, boolean execute) {
        super(header, informationObjectAddress, new CommandValue<Float>(Float.valueOf(value), System.currentTimeMillis()), false, type, execute);
    }

    public SetPointCommandShortFloatingPoint(ASDUHeader header, InformationObjectAddress informationObjectAddress, float value) {
        this(header, informationObjectAddress, value, 0, true);
    }

    @Override
    public SetPointCommandShortFloatingPoint mirror(Cause cause, boolean positive) {
        return new SetPointCommandShortFloatingPoint(this.header.clone(cause, positive), this.informationObjectAddress, this.getValue().getValue().floatValue(), this.getType(), this.isExecute());
    }

    public static SetPointCommandShortFloatingPoint parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress address = InformationObjectAddress.parse(options, data);
        float value = data.readFloat();
        byte b = data.readByte();
        byte type = (byte)(b & 0xFF);
        boolean execute = (b & 0x100) <= 0;
        return new SetPointCommandShortFloatingPoint(header, address, value, type, execute);
    }
}

