/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractSingleCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.ValueCommandMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CommandValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;

@ASDU(id=45, name="C_SC_NA_1", informationStructure=InformationStructure.SINGLE)
public class SingleCommand
extends AbstractSingleCommand
implements ValueCommandMessage {
    public SingleCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, boolean state, byte type, boolean execute) {
        super(header, informationObjectAddress, state ? CommandValue.TRUE() : CommandValue.FALSE(), false, type, execute);
    }

    public SingleCommand(ASDUHeader header, InformationObjectAddress informationObjectAddress, boolean state) {
        this(header, informationObjectAddress, state, 0, true);
    }

    @Override
    public SingleCommand mirror(Cause cause, boolean positive) {
        return new SingleCommand(this.header.clone(cause, positive), this.informationObjectAddress, this.isState(), this.getType(), this.isExecute());
    }

    public static SingleCommand parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress address = InformationObjectAddress.parse(options, data);
        byte b = data.readByte();
        boolean state = (b & 1) > 0;
        byte type = (byte)((b & 0xFC) >> 2);
        boolean execute = (b & 0x100) <= 0;
        return new SingleCommand(header, address, state, type, execute);
    }
}

