/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.neoscada.protocol.iec60870.asdu.message;

import io.netty.buffer.ByteBuf;
import org.eclipse.neoscada.protocol.iec60870.ProtocolOptions;
import org.eclipse.neoscada.protocol.iec60870.asdu.ASDUHeader;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.AbstractSingleCommand;
import org.eclipse.neoscada.protocol.iec60870.asdu.message.ValueCommandMessage;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.ASDU;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.Cause;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.CommandValue;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationObjectAddress;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.InformationStructure;
import org.eclipse.neoscada.protocol.iec60870.asdu.types.TypeHelper;

@ASDU(id=58, name="C_SC_TA_1", informationStructure=InformationStructure.SINGLE)
public class SingleCommandTime
extends AbstractSingleCommand
implements ValueCommandMessage {
    public SingleCommandTime(ASDUHeader header, InformationObjectAddress informationObjectAddress, CommandValue<Boolean> value, byte type, boolean execute) {
        super(header, informationObjectAddress, value, true, type, execute);
    }

    public SingleCommandTime(ASDUHeader header, InformationObjectAddress informationObjectAddress, CommandValue<Boolean> value) {
        this(header, informationObjectAddress, value, 0, true);
    }

    @Override
    public SingleCommandTime mirror(Cause cause, boolean positive) {
        return new SingleCommandTime(this.header.clone(cause, positive), this.informationObjectAddress, this.getValue(), this.getType(), this.isExecute());
    }

    public static SingleCommandTime parse(ProtocolOptions options, byte length, ASDUHeader header, ByteBuf data) {
        InformationObjectAddress address = InformationObjectAddress.parse(options, data);
        byte b = data.readByte();
        boolean state = (b & 1) > 0;
        byte type = (byte)((b & 0xFC) >> 2);
        boolean execute = (b & 0x100) <= 0;
        long timestamp = TypeHelper.parseTimestamp(options, data);
        return new SingleCommandTime(header, address, new CommandValue<Boolean>(state, timestamp), type, execute);
    }
}

