/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib.create;

import java.util.Collection;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.lib.Locator;
import org.eclipse.scada.configuration.lib.Nodes;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.osgi.Connection;
import org.eclipse.scada.configuration.world.osgi.DataAccessConnection;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.SourceItem;
import org.eclipse.scada.utils.str.StringHelper;

public final class Helper {
    private Helper() {
    }

    public static void setSourceConnectionFromEndpoints(SourceItem item, org.eclipse.scada.configuration.world.osgi.MasterServer master, Collection<Endpoint> endpoints) {
        Connection connection = Locator.findConnection((EquinoxApplication)master, endpoints);
        if (connection == null) {
            String nodeName = Nodes.makeName((Node)Nodes.fromApp((Application)master));
            throw new IllegalStateException(String.format("Master '%s' on node '%s' does not have a connection to endpoints %s", master.getName(), nodeName, StringHelper.join(endpoints, (String)", ")));
        }
        if (!(connection instanceof DataAccessConnection)) {
            throw new IllegalStateException(String.format("Connection is of type %s but must be of type %s (Endpoints: %s)", connection.getClass().getName(), DataAccessConnection.class.getName(), StringHelper.join(endpoints, (String)", ")));
        }
        item.setConnection((DataAccessConnection)connection);
    }

    public static AbstractFactoryDriver findDriverForDevice(MasterServer master, Device device) {
        for (Driver driver : master.getDriver()) {
            if (!(driver instanceof AbstractFactoryDriver) || !((AbstractFactoryDriver)driver).getDevices().contains((Object)device)) continue;
            return (AbstractFactoryDriver)driver;
        }
        return null;
    }
}

