/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common.lib;

import java.util.Collection;
import java.util.Map;
import org.eclipse.packagedrone.utils.deb.build.ContentProvider;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.setup.common.Postgres;
import org.eclipse.scada.configuration.setup.common.PostgresSetupModule;
import org.eclipse.scada.configuration.setup.common.lib.InputStreamContentProvider;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.configuration.world.lib.deployment.OperatingSystemDescriptors;
import org.eclipse.scada.configuration.world.lib.setup.SetupModuleHandler;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;

public class PostgresHandler
extends Postgres
implements SetupModuleHandler {
    public PostgresHandler(PostgresSetupModule postgres) {
        super(postgres);
    }

    public void perform(DeploymentContext context, OperatingSystemDescriptor operatingSystem) throws Exception {
        String dbName = this.postgres.getDatabase().getDatabaseName();
        String username = this.postgres.getDatabase().getUsername();
        String password = this.postgres.getDatabase().getPassword();
        String postgresUser = this.postgres.getPostgresUser();
        if (postgresUser == null || postgresUser.isEmpty()) {
            postgresUser = OperatingSystemDescriptors.getProperty((OperatingSystemDescriptor)operatingSystem, (String)"postgresql.user", (String)"root");
        }
        String postgresGroup = OperatingSystemDescriptors.getProperty((OperatingSystemDescriptor)operatingSystem, (String)"postgresql.group", (String)"root");
        Map properties = Properties.makeAttributes((Collection)operatingSystem.getProperties());
        String confFile = this.getConfigurationFile(properties);
        String hbaFile = this.getHostBasedAccessFile(properties);
        context.addInstallDependency("postgresql");
        context.addInstallDependency("postgresql-contrib");
        if (this.postgres.getConfigurationFile() != null && !this.postgres.getConfigurationFile().isEmpty()) {
            context.addFile((ContentProvider)new InputStreamContentProvider(this.openResource(this.postgres.getConfigurationFile())), confFile, new FileInformation(Integer.valueOf(416), postgresUser, postgresGroup, new FileOptions[]{FileOptions.CONFIGURATION}));
        }
        if (this.postgres.getHostBasedAccessFile() != null && !this.postgres.getHostBasedAccessFile().isEmpty()) {
            context.addFile((ContentProvider)new InputStreamContentProvider(this.openResource(this.postgres.getHostBasedAccessFile())), hbaFile, new FileInformation(Integer.valueOf(420), postgresUser, postgresGroup, new FileOptions[]{FileOptions.CONFIGURATION}));
        }
        String command = String.format("esSetupPostgresDatabase -q %s %s %s", PostgresHandler.shellEscape(dbName), PostgresHandler.shellEscape(username), PostgresHandler.shellEscape(password));
        if (postgresUser != null && !postgresUser.isEmpty()) {
            context.runAfterInstallation(String.format("   su - %s -c %s", PostgresHandler.shellEscape(postgresUser), PostgresHandler.shellEscape(command)));
        } else {
            context.runAfterInstallation("   " + command);
        }
    }

    protected static String shellEscape(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("[^a-zA-Z0-9]", "\\\\$0");
        return string;
    }
}

