/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.component.script;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ca.ConfigurationFactory;
import org.eclipse.scada.da.component.script.ScriptComponentFactory;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
implements BundleActivator {
    private static BundleContext context;
    private ScriptComponentFactory factory;
    private ServiceRegistration<ConfigurationFactory> handle;
    private ExecutorService executor;
    private ObjectPoolImpl<DataItem> objectPool;
    private ServiceRegistration<?> poolHandle;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.executor = ExportedExecutorService.newSingleThreadExportedExecutor((String)bundleContext.getBundle().getSymbolicName());
        this.objectPool = new ObjectPoolImpl();
        this.factory = new ScriptComponentFactory(this.executor, this.objectPool, bundleContext);
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("service.vendor", "Eclipse SCADA Project");
        ((Dictionary)properties).put("factoryId", bundleContext.getBundle().getSymbolicName());
        this.handle = bundleContext.registerService(ConfigurationFactory.class, (Object)this.factory, properties);
        this.poolHandle = ObjectPoolHelper.registerObjectPool((BundleContext)bundleContext, this.objectPool, DataItem.class);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.executor.shutdown();
        this.handle.unregister();
        this.factory.dispose();
        this.poolHandle.unregister();
        this.objectPool.dispose();
        context = null;
    }
}

