/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.component.script;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.component.script.ScriptContext;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;

public class ItemWrapper
implements ScriptContext.Item {
    private final DataItemInputChained dataItem;
    private final ObjectPoolImpl<DataItem> objectPool;

    public ItemWrapper(ObjectPoolImpl<DataItem> objectPool, DataItemInputChained dataItem, Map<String, Variant> attributes) {
        this.dataItem = dataItem;
        this.objectPool = objectPool;
        Hashtable<String, String> properties = new Hashtable<String, String>();
        if (attributes.containsKey("description")) {
            ((Dictionary)properties).put("service.description", attributes.get("description").asString(""));
        }
        this.objectPool.addService(dataItem.getInformation().getName(), (Object)dataItem, properties);
    }

    @Override
    public String getItemId() {
        return this.dataItem.getInformation().getName();
    }

    @Override
    public void updateData(Variant value, Map<String, Variant> attributes, AttributeMode attributeMode) {
        this.dataItem.updateData(value, attributes, attributeMode);
    }

    @Override
    public void dispose() {
        this.objectPool.removeService(this.dataItem.getInformation().getName(), (Object)this.dataItem);
    }
}

