/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.common;

import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.server.exporter.common.AbstractSubscriptionManager;
import org.eclipse.scada.da.server.exporter.common.HiveSource;

public class AggregatingSubscriptionManager
extends AbstractSubscriptionManager {
    private final Listener listener;
    protected final ScheduledExecutorService executor;

    public AggregatingSubscriptionManager(ScheduledExecutorService executor, HiveSource hiveSource, Properties properties, String logName, Listener listener) {
        super(hiveSource, properties, executor, logName);
        this.executor = executor;
        this.listener = listener;
    }

    public AggregatingSubscriptionManager(ScheduledExecutorService executor, HiveSource hiveSource, Properties properties, String logName) {
        this(executor, hiveSource, properties, logName, null);
    }

    @Override
    public synchronized void stop() {
        super.stop();
        this.notifyStateUpdate(true);
    }

    private void notifyStateUpdate(final boolean ignoreDisposed) {
        if (this.started && !ignoreDisposed) {
            return;
        }
        if (this.listener == null) {
            return;
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (!AggregatingSubscriptionManager.this.started || ignoreDisposed) {
                    AggregatingSubscriptionManager.this.listener.stateUpdate();
                }
            }
        });
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.notifyStateUpdate(false);
    }

    @Override
    protected void putState(String itemId, DataItemValue value) {
        super.putState(itemId, value);
        this.notifyStateUpdate(false);
    }

    @Override
    public synchronized void subscribe(String itemId) {
        super.subscribe(itemId);
    }

    @Override
    public synchronized void unsubscribe(String itemId) {
        super.unsubscribe(itemId);
    }

    @Override
    public void subscribeAll(Set<String> itemIds) {
        super.subscribeAll(itemIds);
    }

    @FunctionalInterface
    public static interface Listener {
        public void stateUpdate();
    }
}

