/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.da.server.exporter.common.AbstractSubscriptionManager;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSubscriptionManager
extends AbstractSubscriptionManager {
    private static final Logger logger = LoggerFactory.getLogger(SingleSubscriptionManager.class);
    private final ScheduledExecutorService executor;
    private final Map<String, Set<Listener>> listeners = new HashMap<String, Set<Listener>>();

    public SingleSubscriptionManager(ScheduledExecutorService executor, HiveSource hiveSource, Properties properties, String logName) {
        super(hiveSource, properties, executor, logName);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    protected synchronized void putState(final String itemId, final DataItemValue value) {
        super.putState(itemId, value);
        Set<Listener> set = this.listeners.get(itemId);
        if (set == null) {
            logger.debug("No listener set for: {}", (Object)itemId);
            return;
        }
        for (final Listener listener : set) {
            logger.trace("Notify listener - itemId: {}, listener: {}", (Object)itemId, (Object)listener);
            try {
                this.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.stateChanged(itemId, value);
                    }
                });
            }
            catch (Throwable e) {
                logger.warn("Failed to notify", e);
            }
        }
    }

    public synchronized void addListener(final String itemId, final Listener listener) {
        if (itemId == null) {
            throw new NullPointerException("'itemId' must not be null");
        }
        if (listener == null) {
            throw new NullPointerException("'listener' must not be null");
        }
        Set<Listener> set = this.listeners.get(itemId);
        if (set == null) {
            set = new HashSet<Listener>(1);
            this.listeners.put(itemId, set);
        }
        if (!set.add(listener)) {
            return;
        }
        if (set.size() == 1) {
            this.subscribe(itemId);
        } else {
            final DataItemValue value = (DataItemValue)this.cache.get(itemId);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    listener.stateChanged(itemId, value);
                }
            });
        }
    }

    public synchronized void removeListener(final String itemId, final Listener listener) {
        if (itemId == null) {
            throw new NullPointerException("'itemId' must not be null");
        }
        if (listener == null) {
            throw new NullPointerException("'listener' must not be null");
        }
        Set<Listener> set = this.listeners.get(itemId);
        if (set == null) {
            return;
        }
        if (!set.remove(listener)) {
            return;
        }
        if (set.isEmpty()) {
            this.unsubscribe(itemId);
        }
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.stateChanged(itemId, null);
            }
        });
    }

    @FunctionalInterface
    public static interface Listener {
        public void stateChanged(String var1, DataItemValue var2);
    }
}

