/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ngp;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.server.exporter.ExporterInformation;
import org.eclipse.scada.da.common.ngp.ProtocolConfigurationFactoryImpl;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.ngp.Server;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.eclipse.scada.utils.lifecycle.LifecycleAware;

public class Exporter
implements LifecycleAware {
    private Server server;
    private final ProtocolConfigurationFactory protocolConfigurationFactory;
    private Collection<InetSocketAddress> addresses = new LinkedList<InetSocketAddress>();
    private final Hive service;
    private Set<InetSocketAddress> startedAddresses;

    public Exporter(Hive service, ProtocolConfigurationFactory protocolConfigurationFactory, Collection<InetSocketAddress> addresses) {
        this.service = service;
        this.protocolConfigurationFactory = protocolConfigurationFactory;
        this.addresses = addresses;
    }

    public Exporter(Hive service, ConnectionInformation connectionInformation) throws Exception {
        this(service, (ProtocolConfigurationFactory)new ProtocolConfigurationFactoryImpl(connectionInformation), Collections.singletonList(new InetSocketAddress(connectionInformation.getTarget(), (int)connectionInformation.getSecondaryTarget())));
    }

    public Class<? extends Hive> getServiceClass() {
        return this.service.getClass();
    }

    private Set<InetSocketAddress> createServer() throws Exception {
        this.server = new Server(this.addresses, this.protocolConfigurationFactory, this.service);
        return this.server.start();
    }

    public void start() throws Exception {
        if (this.startedAddresses == null) {
            this.startedAddresses = this.createServer();
        }
    }

    public Set<InetSocketAddress> getStartedAddresses() {
        return this.startedAddresses;
    }

    public Set<ConnectionInformation> getStartedConnectionInformations() {
        return this.convert("da", this.getStartedAddresses());
    }

    public Set<ExporterInformation> getExporterInformation() {
        HashSet<ExporterInformation> result = new HashSet<ExporterInformation>();
        for (ConnectionInformation ci : this.getStartedConnectionInformations()) {
            result.add(new ExporterInformation(ci, null));
        }
        return result;
    }

    Set<ConnectionInformation> convert(String interfaceName, Set<InetSocketAddress> startedAddresses) {
        HashSet<ConnectionInformation> result = new HashSet<ConnectionInformation>();
        for (InetSocketAddress address : startedAddresses) {
            String target = address.getAddress().getHostAddress().replace("%", "%25");
            ConnectionInformation ci = target.indexOf(58) >= 0 ? ConnectionInformation.fromURI((String)String.format("%s:ngp://[%s]:%s", interfaceName, target, address.getPort())) : ConnectionInformation.fromURI((String)String.format("%s:ngp://%s:%s", interfaceName, target, address.getPort()));
            if (ci == null) continue;
            result.add(ci);
        }
        return result;
    }

    public void stop() throws Exception {
        this.destroyServer();
    }

    private void destroyServer() {
        if (this.server != null) {
            this.server.dispose();
            this.server = null;
            this.startedAddresses = null;
        }
    }
}

