/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ngp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.mina.core.session.IoSession;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.core.data.ErrorInformation;
import org.eclipse.scada.core.data.Response;
import org.eclipse.scada.core.data.SubscriptionState;
import org.eclipse.scada.core.server.Service;
import org.eclipse.scada.core.server.ngp.ServiceServerConnection;
import org.eclipse.scada.da.core.Location;
import org.eclipse.scada.da.core.WriteAttributeResult;
import org.eclipse.scada.da.core.WriteAttributeResults;
import org.eclipse.scada.da.core.WriteResult;
import org.eclipse.scada.da.core.browser.DataItemEntry;
import org.eclipse.scada.da.core.browser.Entry;
import org.eclipse.scada.da.core.browser.FolderEntry;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.core.server.ItemChangeListener;
import org.eclipse.scada.da.core.server.Session;
import org.eclipse.scada.da.core.server.browser.FolderListener;
import org.eclipse.scada.da.core.server.browser.NoSuchFolderException;
import org.eclipse.scada.da.data.AttributeWriteResultEntry;
import org.eclipse.scada.da.data.BrowserEntry;
import org.eclipse.scada.da.data.FolderEntryType;
import org.eclipse.scada.da.data.message.BrowseFolder;
import org.eclipse.scada.da.data.message.BrowseResult;
import org.eclipse.scada.da.data.message.FolderDataUpdate;
import org.eclipse.scada.da.data.message.ItemDataUpdate;
import org.eclipse.scada.da.data.message.ItemStateUpdate;
import org.eclipse.scada.da.data.message.StartWriteAttributes;
import org.eclipse.scada.da.data.message.StartWriteValue;
import org.eclipse.scada.da.data.message.SubscribeFolder;
import org.eclipse.scada.da.data.message.SubscribeItem;
import org.eclipse.scada.da.data.message.UnsubscibeItem;
import org.eclipse.scada.da.data.message.UnsubscribeFolder;
import org.eclipse.scada.da.data.message.WriteAttributesResult;
import org.eclipse.scada.da.data.message.WriteValueResult;
import org.eclipse.scada.da.server.ngp.AttributesTransport;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.scada.utils.concurrent.FutureListener;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnectionImpl
extends ServiceServerConnection<Session, Hive> {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnectionImpl.class);
    private final ItemChangeListener itemChangeListener = new ItemChangeListener(){

        public void subscriptionChanged(String itemId, SubscriptionState subscriptionState) {
            ServerConnectionImpl.this.handleSubscriptionChanged(itemId, subscriptionState);
        }

        public void dataChanged(String itemId, Variant value, Map<String, Variant> attributes, boolean cache) {
            ServerConnectionImpl.this.handleDataChanged(itemId, value, attributes, cache);
        }
    };
    private final FolderListener folderListener = new FolderListener(){

        public void folderChanged(Location location, List<Entry> added, Set<String> removed, boolean full) {
            ServerConnectionImpl.this.handleFolderChanged(location, added, removed, full);
        }
    };

    public ServerConnectionImpl(IoSession session, Hive service) {
        super(session, (Service)service);
    }

    private static List<BrowserEntry> convertEntries(Collection<Entry> added) {
        if (added == null) {
            return null;
        }
        ArrayList<BrowserEntry> result = new ArrayList<BrowserEntry>(added.size());
        for (Entry entry : added) {
            BrowserEntry newEntry = ServerConnectionImpl.convertEntry(entry);
            if (newEntry == null) continue;
            result.add(newEntry);
        }
        return result;
    }

    private static BrowserEntry convertEntry(Entry entry) {
        if (entry instanceof FolderEntry) {
            return new BrowserEntry(entry.getName(), FolderEntryType.FOLDER, null, entry.getAttributes(), null);
        }
        if (entry instanceof DataItemEntry) {
            return new BrowserEntry(entry.getName(), FolderEntryType.ITEM, ((DataItemEntry)entry).getId(), entry.getAttributes(), ((DataItemEntry)entry).getIODirections());
        }
        return null;
    }

    protected void handleDataChanged(String itemId, Variant value, Map<String, Variant> attributes, boolean cache) {
        AttributesTransport transport = new AttributesTransport(attributes);
        this.sendMessage(new ItemDataUpdate(itemId, value, transport.getAddedOrUpdated(), transport.getRemoved(), cache));
    }

    protected void handleSubscriptionChanged(String itemId, SubscriptionState subscriptionState) {
        this.sendMessage(new ItemStateUpdate(itemId, subscriptionState, null));
    }

    protected void handleFolderChanged(Location location, Collection<Entry> added, Set<String> removed, boolean full) {
        this.sendMessage(new FolderDataUpdate(location.asList(), ServerConnectionImpl.convertEntries(added), removed, full));
    }

    protected void initializeSession(Session session) {
        super.initializeSession((org.eclipse.scada.core.server.Session)session);
        session.setListener(this.itemChangeListener);
        session.setListener(this.folderListener);
    }

    public void handleMessageReceived(Object message) throws Exception {
        if (message instanceof SubscribeItem) {
            this.handleSubscribeItem((SubscribeItem)message);
        } else if (message instanceof UnsubscibeItem) {
            this.handleUnsubscibeItem((UnsubscibeItem)message);
        } else if (message instanceof SubscribeFolder) {
            this.handelSubscribeFolder((SubscribeFolder)message);
        } else if (message instanceof UnsubscribeFolder) {
            this.handelUnsubscribeFolder((UnsubscribeFolder)message);
        } else if (message instanceof BrowseFolder) {
            this.handleBrowseFolder((BrowseFolder)message);
        } else if (message instanceof StartWriteValue) {
            this.handleStartWriteValue((StartWriteValue)message);
        } else if (message instanceof StartWriteAttributes) {
            this.handleStartWriteAttributes((StartWriteAttributes)message);
        } else {
            super.handleMessageReceived(message);
        }
    }

    private void handleStartWriteValue(final StartWriteValue message) {
        try {
            CallbackHandler callbackHandler = this.createCallbackHandler(message.getCallbackHandlerId());
            NotifyFuture future = ((Hive)this.service).startWrite((Session)this.session, message.getItemId(), message.getValue(), message.getOperationParameters(), callbackHandler);
            future.addListener((FutureListener)new FutureListener<WriteResult>(){

                public void complete(Future<WriteResult> future) {
                    try {
                        future.get();
                        ServerConnectionImpl.this.sendMessage(new WriteValueResult(new Response(message.getRequest()), null));
                    }
                    catch (Exception e) {
                        logger.warn("Failed to complete write value", (Throwable)e);
                        ServerConnectionImpl.this.sendWriteValueError(message, e, 5L);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to start write value", (Throwable)e);
            this.sendWriteValueError(message, e, 4L);
        }
    }

    private void sendWriteValueError(StartWriteValue message, Exception e, Long code) {
        this.sendMessage(new WriteValueResult(new Response(message.getRequest()), new ErrorInformation(code, e.getMessage(), ExceptionHelper.formatted((Throwable)e))));
    }

    private void handleStartWriteAttributes(final StartWriteAttributes message) {
        try {
            CallbackHandler callbackHandler = this.createCallbackHandler(message.getCallbackHandlerId());
            NotifyFuture future = ((Hive)this.service).startWriteAttributes((Session)this.session, message.getItemId(), message.getAttributes(), message.getOperationParameters(), callbackHandler);
            future.addListener((FutureListener)new FutureListener<WriteAttributeResults>(){

                public void complete(Future<WriteAttributeResults> future) {
                    try {
                        WriteAttributeResults result = future.get();
                        ServerConnectionImpl.this.sendMessage(new WriteAttributesResult(new Response(message.getRequest()), ServerConnectionImpl.this.convertResult(result), null));
                    }
                    catch (Exception e) {
                        logger.warn("Failed to complete write attributes", (Throwable)e);
                        ServerConnectionImpl.this.sendWriteAttributesError(message, e, 7L);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to start write attributes", (Throwable)e);
            this.sendWriteAttributesError(message, e, 6L);
        }
    }

    protected List<AttributeWriteResultEntry> convertResult(WriteAttributeResults attributeResult) {
        if (attributeResult == null) {
            return null;
        }
        ArrayList<AttributeWriteResultEntry> result = new ArrayList<AttributeWriteResultEntry>(attributeResult.size());
        for (Map.Entry entry : attributeResult.entrySet()) {
            result.add(new AttributeWriteResultEntry((String)entry.getKey(), this.convertEntry((WriteAttributeResult)entry.getValue())));
        }
        return result;
    }

    private ErrorInformation convertEntry(WriteAttributeResult value) {
        if (value == null || value.isSuccess() || value.getError() == null) {
            return null;
        }
        return new ErrorInformation(null, value.getError().getMessage(), ExceptionHelper.formatted((Throwable)value.getError()));
    }

    private void sendWriteAttributesError(StartWriteAttributes message, Exception e, Long code) {
        this.sendMessage(new WriteAttributesResult(new Response(message.getRequest()), null, new ErrorInformation(code, e.getMessage(), ExceptionHelper.formatted((Throwable)e))));
    }

    private void handleBrowseFolder(final BrowseFolder message) {
        try {
            NotifyFuture future = ((Hive)this.service).getBrowser().startBrowse((Session)this.session, new Location(message.getLocation()));
            future.addListener((FutureListener)new FutureListener<Entry[]>(){

                public void complete(Future<Entry[]> future) {
                    try {
                        Entry[] result = future.get();
                        ServerConnectionImpl.this.sendMessage(new BrowseResult(new Response(message.getRequest()), ServerConnectionImpl.this.convertEntries(result), null));
                    }
                    catch (Exception e) {
                        logger.warn("Browse completed with error", (Throwable)e);
                        ServerConnectionImpl.this.sendBrowseError(message, e, 3L);
                    }
                }
            });
        }
        catch (Exception e) {
            logger.warn("Failed to browse", (Throwable)e);
            this.sendBrowseError(message, e, 2L);
        }
    }

    protected List<BrowserEntry> convertEntries(Entry[] result) {
        return ServerConnectionImpl.convertEntries(Arrays.asList(result));
    }

    private void handelSubscribeFolder(SubscribeFolder message) {
        try {
            ((Hive)this.service).getBrowser().subscribe((Session)this.session, new Location(message.getLocation()));
        }
        catch (Exception e) {
            logger.warn("Failed to subscribe", (Throwable)e);
        }
    }

    private void handelUnsubscribeFolder(UnsubscribeFolder message) {
        try {
            ((Hive)this.service).getBrowser().unsubscribe((Session)this.session, new Location(message.getLocation()));
        }
        catch (NoSuchFolderException e) {
            logger.debug("Folder was already gone", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn("Failed to unsubscribe", (Throwable)e);
        }
    }

    private void handleUnsubscibeItem(UnsubscibeItem message) {
        try {
            ((Hive)this.service).unsubscribeItem((Session)this.session, message.getItemId());
        }
        catch (Exception e) {
            logger.warn("Failed to unsubscribe", (Throwable)e);
            this.sendMessage(new ItemStateUpdate(message.getItemId(), SubscriptionState.DISCONNECTED, new ErrorInformation(Long.valueOf(1L), e.getMessage(), ExceptionHelper.formatted((Throwable)e))));
        }
    }

    private void handleSubscribeItem(SubscribeItem message) {
        try {
            ((Hive)this.service).subscribeItem((Session)this.session, message.getItemId());
        }
        catch (Exception e) {
            logger.warn("Failed to subscribe", (Throwable)e);
            this.sendMessage(new ItemStateUpdate(message.getItemId(), SubscriptionState.DISCONNECTED, new ErrorInformation(Long.valueOf(1L), e.getMessage(), ExceptionHelper.formatted((Throwable)e))));
        }
    }

    private void sendBrowseError(BrowseFolder message, Exception e, Long code) {
        this.sendMessage(new BrowseResult(new Response(message.getRequest()), null, new ErrorInformation(code, e.getMessage(), ExceptionHelper.formatted((Throwable)e))));
    }
}

