/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.client.ngp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.client.ConnectionState;
import org.eclipse.scada.core.client.ngp.ConnectionBaseImpl;
import org.eclipse.scada.hd.ItemListListener;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.client.Connection;
import org.eclipse.scada.hd.client.ngp.ErrorQueryImpl;
import org.eclipse.scada.hd.client.ngp.ItemManager;
import org.eclipse.scada.hd.client.ngp.QueryImpl;
import org.eclipse.scada.hd.common.ngp.ProtocolConfigurationFactoryImpl;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.message.ChangeQueryParameters;
import org.eclipse.scada.hd.data.message.CloseQuery;
import org.eclipse.scada.hd.data.message.CreateQuery;
import org.eclipse.scada.hd.data.message.ListUpdate;
import org.eclipse.scada.hd.data.message.StartBrowse;
import org.eclipse.scada.hd.data.message.StopBrowse;
import org.eclipse.scada.hd.data.message.UpdateQueryData;
import org.eclipse.scada.hd.data.message.UpdateQueryParameters;
import org.eclipse.scada.hd.data.message.UpdateQueryState;
import org.eclipse.scada.protocol.ngp.common.ProtocolConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionImpl
extends ConnectionBaseImpl
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionImpl.class);
    private static final Object STATS_OPEN_QUERIES = new Object();
    private final ItemManager itemManager;
    private final Map<Long, QueryImpl> queries = new HashMap<Long, QueryImpl>();
    private final Random queryIdRandom = new Random();

    public ConnectionImpl(ConnectionInformation connectionInformation) throws Exception {
        this(connectionInformation, null);
    }

    public ConnectionImpl(ConnectionInformation connectionInformation, IoProcessor<NioSession> processor) throws Exception {
        super((ProtocolConfigurationFactory)new ProtocolConfigurationFactoryImpl(connectionInformation), connectionInformation, processor);
        this.itemManager = new ItemManager(this.executor, this);
        this.statistics.setLabel(STATS_OPEN_QUERIES, "Open queries");
    }

    public synchronized void dispose() {
        this.itemManager.dispose();
        super.dispose();
    }

    protected void onConnectionBound() {
        this.itemManager.onConnectionBound();
    }

    protected void onConnectionClosed() {
        super.onConnectionClosed();
        this.itemManager.onConnectionClosed();
        ArrayList<QueryImpl> queries = new ArrayList<QueryImpl>(this.queries.values());
        this.queries.clear();
        this.statistics.setCurrentValue(STATS_OPEN_QUERIES, (double)this.queries.size());
        for (QueryImpl query : queries) {
            try {
                query.close();
            }
            catch (Exception e) {
                logger.warn("Failed to close query on disconnect", (Throwable)e);
            }
        }
    }

    public synchronized Query createQuery(String itemId, QueryParameters parameters, QueryListener listener, boolean updateData) {
        if (this.getState() != ConnectionState.BOUND) {
            return new ErrorQueryImpl(this.executor, listener);
        }
        long queryId = this.findFreeQueryId();
        QueryImpl query = new QueryImpl(this.executor, this, queryId, itemId, parameters, listener);
        this.queries.put(queryId, query);
        this.statistics.setCurrentValue(STATS_OPEN_QUERIES, (double)this.queries.size());
        this.sendCreateQuery(queryId, itemId, parameters, updateData);
        return query;
    }

    private long findFreeQueryId() {
        long queryId;
        while (this.queries.containsKey(queryId = this.queryIdRandom.nextLong())) {
        }
        return queryId;
    }

    public synchronized void addListListener(ItemListListener listener) {
        this.itemManager.addListListener(listener);
    }

    public synchronized void removeListListener(ItemListListener listener) {
        this.itemManager.removeListListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeQuery(Long queryId) {
        if (queryId == null) {
            return;
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            if (this.queries.remove(queryId) != null) {
                this.sendCloseQuery(queryId);
                this.statistics.setCurrentValue(STATS_OPEN_QUERIES, (double)this.queries.size());
            }
        }
    }

    protected void updateQueryParameters(QueryImpl query, QueryParameters parameters) {
        Long id = query.getId();
        if (id == null) {
            return;
        }
        this.sendQueryUpdateParameters(query.getId(), parameters);
    }

    protected synchronized void handleMessage(Object message) {
        if (message instanceof UpdateQueryState) {
            this.handleUpdateQueryState((UpdateQueryState)message);
        } else if (message instanceof UpdateQueryParameters) {
            this.handleUpdateQueryParameters((UpdateQueryParameters)message);
        } else if (message instanceof UpdateQueryData) {
            this.handleUpdateQueryData((UpdateQueryData)message);
        } else if (message instanceof ListUpdate) {
            this.handleListUpdate((ListUpdate)message);
        } else {
            super.handleMessage(message);
        }
    }

    private void handleListUpdate(ListUpdate message) {
        logger.debug("List update - addedOrModified: {}, removed: {}, full: {}", new Object[]{message.getAddedOrModified(), message.getRemoved(), message.isFullUpdate()});
        this.itemManager.handleListUpdate(message.getAddedOrModified(), message.getRemoved(), message.isFullUpdate());
    }

    private void handleUpdateQueryData(UpdateQueryData message) {
        QueryImpl query = this.queries.get(message.getQueryId());
        if (query == null) {
            logger.info("Query is already closed");
            return;
        }
        query.handleUpdateData(message.getIndex(), message.getValues(), message.getValueInformation());
    }

    private void handleUpdateQueryParameters(UpdateQueryParameters message) {
        QueryImpl query = this.queries.get(message.getQueryId());
        if (query == null) {
            logger.info("Query is already closed");
            return;
        }
        query.handleUpdateParameter(message.getQueryParameters(), message.getValueTypes());
    }

    private void handleUpdateQueryState(UpdateQueryState message) {
        QueryImpl query = this.queries.get(message.getQueryId());
        if (query == null) {
            logger.info("Query is already closed");
            return;
        }
        query.handleUpdateStatus(QueryState.valueOf((String)message.getState()));
    }

    void sendCreateQuery(long queryId, String itemId, QueryParameters parameters, boolean updateData) {
        this.sendMessage(new CreateQuery(this.nextRequest(), queryId, itemId, updateData, parameters));
    }

    protected void sendCloseQuery(long queryId) {
        this.sendMessage(new CloseQuery(queryId));
    }

    protected void sendQueryUpdateParameters(long id, QueryParameters parameters) {
        this.sendMessage(new ChangeQueryParameters(id, parameters));
    }

    protected void sendBrowseRequestState(boolean state) {
        logger.debug("Requesting browse state: {}", (Object)state);
        if (state) {
            this.sendMessage(new StartBrowse());
        } else {
            this.sendMessage(new StopBrowse());
        }
    }
}

