/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.proxy;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Executor;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.server.proxy.QueryDataHolder;
import org.eclipse.scada.hd.server.storage.common.DataFactory;
import org.eclipse.scada.hd.server.storage.common.QueryDataBuffer;

public class ProxyQueryBuffer
extends QueryDataBuffer {
    private Data[] data;
    private QueryParameters parameters;

    public ProxyQueryBuffer(QueryListener listener, QueryParameters parameters, Executor executor) {
        super(listener, executor, null, null);
        this.setParameters(parameters);
    }

    protected Data[] getData() {
        return this.data;
    }

    public synchronized void close() {
        if (this.state == QueryState.DISCONNECTED) {
            return;
        }
        this.notifyStateUpdate(QueryState.DISCONNECTED);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void render(List<? extends QueryDataHolder> holders) {
        void var3_6;
        if (this.state == QueryState.DISCONNECTED) {
            return;
        }
        QueryDataBuffer.Data[] data = new Data[this.data.length];
        ProxyQueryBuffer.fillDataCells((QueryDataBuffer.Data[])data, (long)this.parameters.getStartTimestamp(), (long)this.parameters.getEndTimestamp(), (DataFactory)new DataFactory(){

            public QueryDataBuffer.Data create(Date start, Date end) {
                return new Data(start, end);
            }
        });
        for (QueryDataHolder queryDataHolder : holders) {
            List<Double> min;
            List<Double> max;
            List<Double> avg;
            HashMap<String, List<Double>> values;
            List<ValueInformation> information = queryDataHolder.getValueInformation();
            if (information == null || (values = queryDataHolder.getValues()) == null || information.size() != data.length || (avg = values.get("AVG")) == null || (max = values.get("MAX")) == null || (min = values.get("MIN")) == null) continue;
            int i = 0;
            while (i < Math.min(data.length, information.size())) {
                ValueInformation entryInformation = information.get(i);
                Double entryAvg = avg.get(i);
                Double entryMax = max.get(i);
                Double entryMin = min.get(i);
                if (entryAvg != null && entryMax != null && entryMin != null && entryInformation != null && !(data[i].getQuality() >= entryInformation.getQuality())) {
                    data[i].setEntryCount(entryInformation.getSourceValues());
                    data[i].setQuality(entryInformation.getQuality());
                    data[i].setManual(entryInformation.getManualPercentage());
                    data[i].setAverage(entryAvg.doubleValue());
                    data[i].setMax(entryMax.doubleValue());
                    data[i].setMin(entryMin.doubleValue());
                }
                ++i;
            }
        }
        boolean bl = false;
        while (var3_6 < Math.min(data.length, this.data.length)) {
            this.data[var3_6].apply((Data)data[var3_6]);
            ++var3_6;
        }
        this.notifyData(0, this.data.length);
        this.notifyStateUpdate(this.updateState(holders));
    }

    private QueryState updateState(List<? extends QueryDataHolder> holders) {
        for (QueryDataHolder queryDataHolder : holders) {
            if (queryDataHolder.getState() != QueryState.LOADING) continue;
            return QueryState.LOADING;
        }
        return QueryState.COMPLETE;
    }

    public synchronized void changeParameters(QueryParameters parameters) {
        if (this.state == QueryState.DISCONNECTED) {
            return;
        }
        this.setParameters(parameters);
        this.notifyData(0, this.data.length);
    }

    private void setParameters(QueryParameters parameters) {
        this.parameters = parameters;
        this.data = new Data[parameters.getNumberOfEntries()];
        ProxyQueryBuffer.fillDataCells((QueryDataBuffer.Data[])this.data, (long)parameters.getStartTimestamp(), (long)parameters.getEndTimestamp(), (DataFactory)new DataFactory(){

            public QueryDataBuffer.Data create(Date start, Date end) {
                return new Data(start, end);
            }
        });
        this.notifyParameterUpdate(parameters, new LinkedHashSet<String>(Arrays.asList("AVG", "MIN", "MAX")));
    }

    private static class Data
    extends QueryDataBuffer.Data {
        private long entryCount;

        public Data(Date start, Date end) {
            super(start, end);
        }

        public void setEntryCount(long entryCount) {
            if (this.entryCount != entryCount) {
                this.changed = true;
                this.entryCount = entryCount;
            }
        }

        public long getEntryCount() {
            return this.entryCount;
        }

        public void apply(Data data) {
            super.apply((QueryDataBuffer.Data)data);
            this.setEntryCount(data.entryCount);
        }
    }
}

