/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.server.proxy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.scada.hd.Query;
import org.eclipse.scada.hd.QueryListener;
import org.eclipse.scada.hd.QueryState;
import org.eclipse.scada.hd.data.QueryParameters;
import org.eclipse.scada.hd.data.ValueInformation;
import org.eclipse.scada.hd.server.common.HistoricalItem;
import org.eclipse.scada.hd.server.proxy.ProxyHistoricalItem;
import org.eclipse.scada.hd.server.proxy.ProxyQueryBuffer;
import org.eclipse.scada.hd.server.proxy.ProxyValueSource;
import org.eclipse.scada.hd.server.proxy.QueryDataHolder;

public class QueryImpl
implements Query,
ProxyHistoricalItem.ItemListener {
    private final ProxyHistoricalItem item;
    private QueryParameters parameters;
    private final boolean updateData;
    private final Executor executor;
    private final Set<ProxyValueSource.ServiceEntry> items = new HashSet<ProxyValueSource.ServiceEntry>();
    private final Map<HistoricalItem, QueryEntry> queries = new HashMap<HistoricalItem, QueryEntry>();
    private final ProxyQueryBuffer queryBuffer;

    public QueryImpl(ProxyHistoricalItem item, QueryParameters parameters, QueryListener listener, boolean updateData, Executor executor) {
        this.item = item;
        this.parameters = parameters;
        this.updateData = updateData;
        this.executor = executor;
        this.queryBuffer = new ProxyQueryBuffer(listener, parameters, executor);
        item.addListener(this);
    }

    public synchronized void close() {
        this.queryBuffer.close();
        this.item.removeListener(this);
        for (QueryEntry query : this.queries.values()) {
            query.getQuery().close();
        }
    }

    public synchronized void changeParameters(final QueryParameters parameters) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                QueryImpl.this.handleChangeParameters(parameters);
            }
        });
    }

    protected synchronized void handleChangeParameters(QueryParameters parameters) {
        this.parameters = parameters;
        this.queryBuffer.changeParameters(parameters);
        for (QueryEntry query : this.queries.values()) {
            query.getQuery().changeParameters(parameters);
        }
    }

    @Override
    public synchronized void listenersChanges(final Collection<ProxyValueSource.ServiceEntry> added, final Collection<ProxyValueSource.ServiceEntry> removed) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                QueryImpl.this.performChange(added, removed);
            }
        });
    }

    private synchronized void performChange(Collection<ProxyValueSource.ServiceEntry> added, Collection<ProxyValueSource.ServiceEntry> removed) {
        for (ProxyValueSource.ServiceEntry item : added) {
            if (!this.items.add(item)) continue;
            QueryEntry entry = new QueryEntry(this, item.getPriority());
            Query query = item.getItem().createQuery(this.parameters, (QueryListener)entry, this.updateData);
            entry.setQuery(query);
            this.queries.put(item.getItem(), entry);
        }
        for (ProxyValueSource.ServiceEntry item : removed) {
            QueryEntry query;
            if (!this.items.remove(item) || (query = this.queries.remove(item.getItem())) == null) continue;
            query.getQuery().close();
        }
    }

    public synchronized void render() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                QueryImpl.this.performRender();
            }
        });
    }

    protected synchronized void performRender() {
        ArrayList<QueryEntry> entries = new ArrayList<QueryEntry>(this.queries.values());
        Collections.sort(entries);
        this.queryBuffer.render(entries);
    }

    public static class QueryEntry
    implements QueryListener,
    QueryDataHolder,
    Comparable<QueryEntry> {
        private Query query;
        private final QueryImpl impl;
        private QueryState state;
        private Set<String> valueTypes;
        private QueryParameters parameters;
        private HashMap<String, List<Double>> values;
        private List<ValueInformation> valueInformation;
        private final int priority;

        public QueryEntry(QueryImpl impl, int priority) {
            this.impl = impl;
            this.priority = priority;
        }

        public void setQuery(Query query) {
            this.query = query;
        }

        public Query getQuery() {
            return this.query;
        }

        @Override
        public QueryParameters getParameters() {
            return this.parameters;
        }

        @Override
        public QueryState getState() {
            return this.state;
        }

        @Override
        public List<ValueInformation> getValueInformation() {
            return this.valueInformation;
        }

        @Override
        public HashMap<String, List<Double>> getValues() {
            return this.values;
        }

        public void updateState(QueryState state) {
            this.state = state;
            this.render();
        }

        public void updateParameters(QueryParameters parameters, Set<String> valueTypes) {
            this.parameters = parameters;
            this.valueTypes = valueTypes;
            int size = parameters.getNumberOfEntries();
            this.values = new HashMap();
            for (String type : valueTypes) {
                this.values.put(type, new ArrayList<Double>(Arrays.asList(new Double[size])));
            }
            this.valueInformation = new ArrayList<ValueInformation>(Arrays.asList(new ValueInformation[size]));
            this.render();
        }

        public void updateData(int index, Map<String, List<Double>> values, List<ValueInformation> valueInformation) {
            List<ValueInformation> subVi = this.valueInformation.subList(index, index + valueInformation.size());
            subVi.clear();
            subVi.addAll(valueInformation);
            for (Map.Entry<String, List<Double>> entry : values.entrySet()) {
                List<Double> valueArray = this.values.get(entry.getKey());
                List<Double> subVs = valueArray.subList(index, index + valueInformation.size());
                subVs.clear();
                subVs.addAll((Collection<Double>)entry.getValue());
            }
            this.render();
        }

        private void render() {
            this.impl.render();
        }

        @Override
        public int compareTo(QueryEntry o) {
            return Integer.valueOf(this.priority).compareTo(o.priority);
        }
    }
}

