/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage.jdbc.internal;

import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.storage.jdbc.internal.BufferingStorageDaoMXBean;
import org.eclipse.scada.ds.storage.jdbc.internal.JdbcStorageDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferingStorageDao
implements BufferingStorageDaoMXBean,
JdbcStorageDao {
    private static final Logger logger = LoggerFactory.getLogger(BufferingStorageDao.class);
    private final JdbcStorageDao targetDao;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private Map<String, DataNode> queueMap = new HashMap<String, DataNode>();
    private Map<String, DataNode> writeMap = new HashMap<String, DataNode>();
    private final Condition writeCondition = this.writeLock.newCondition();
    private boolean disposed;
    private volatile Thread writerThread;
    private final MBeanServer mbs;
    private ObjectName name;

    public BufferingStorageDao(JdbcStorageDao targetDao) {
        this.targetDao = targetDao;
        this.startWriter();
        this.mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            this.name = new ObjectName("org.eclipse.scada.ds.storage.jdbc.JdbcStorageDao", "key", "BufferingStorageDao");
            this.mbs.registerMBean(this, this.name);
        }
        catch (Exception e) {
            logger.warn("Failed to export", (Throwable)e);
        }
    }

    protected synchronized void startWriter() {
        if (this.disposed) {
            logger.warn("We are disposed. Not starting writer");
            return;
        }
        this.writerThread = new Thread("BufferingStorageDao"){

            @Override
            public void run() {
                BufferingStorageDao.this.writer();
            }
        };
        this.writerThread.start();
        this.writerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.error("Writer thread failed. Restarting ...", e);
                BufferingStorageDao.this.startWriter();
            }
        });
    }

    @Override
    public Collection<DataNode> readAllNodes() {
        try {
            this.readLock.lock();
            if (this.disposed) {
                return null;
            }
            HashSet<DataNode> result = new HashSet<DataNode>();
            result.addAll(this.targetDao.readAllNodes());
            result.addAll(this.writeMap.values());
            result.addAll(this.queueMap.values());
            HashSet<DataNode> hashSet = result;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public DataNode readNode(String nodeId) {
        try {
            this.readLock.lock();
            if (this.disposed) {
                return null;
            }
            if (this.queueMap.containsKey(nodeId)) {
                DataNode dataNode = this.queueMap.get(nodeId);
                return dataNode;
            }
            if (this.writeMap.containsKey(nodeId)) {
                DataNode dataNode = this.writeMap.get(nodeId);
                return dataNode;
            }
            DataNode dataNode = this.targetDao.readNode(nodeId);
            return dataNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void writeNode(DataNode node) {
        try {
            this.writeLock.lock();
            if (this.disposed) {
                return;
            }
            this.queueMap.put(node.getId(), node);
            this.writeCondition.signal();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void deleteNode(String nodeId) {
        try {
            this.writeLock.lock();
            if (this.disposed) {
                return;
            }
            this.queueMap.put(nodeId, null);
            this.writeCondition.signal();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void writer() {
        logger.info("Starting writer");
        while (true) {
            block13: {
                try {
                    try {
                        this.writeLock.lock();
                        this.writeCondition.await(1L, TimeUnit.MINUTES);
                        this.writeMap.putAll(this.queueMap);
                        this.queueMap = new HashMap<String, DataNode>();
                    }
                    catch (InterruptedException interruptedException) {
                        this.writeLock.unlock();
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    this.writeLock.unlock();
                    throw throwable;
                }
                this.writeLock.unlock();
            }
            Map<String, DataNode> failMap = this.performWrites();
            try {
                this.writeLock.lock();
                this.writeMap = new HashMap<String, DataNode>(failMap);
            }
            finally {
                this.writeLock.unlock();
            }
            try {
                this.readLock.lock();
                if (!this.writeMap.isEmpty()) {
                    logger.error("Write map still contains {} entries but we are exiting!", (Object)this.writeMap.size());
                }
                if (!this.disposed) continue;
                logger.info("Detected shutdown signal");
                this.targetDao.dispose();
                return;
            }
            finally {
                this.readLock.unlock();
                continue;
            }
            break;
        }
    }

    private Map<String, DataNode> performWrites() {
        HashMap<String, DataNode> failMap = new HashMap<String, DataNode>(this.writeMap.size());
        for (Map.Entry<String, DataNode> entry : this.writeMap.entrySet()) {
            try {
                if (entry.getValue() == null) {
                    this.targetDao.deleteNode(entry.getKey());
                    continue;
                }
                this.targetDao.writeNode(entry.getValue());
            }
            catch (Exception e) {
                failMap.put(entry.getKey(), entry.getValue());
                logger.warn("Failed to store data node", (Throwable)e);
            }
        }
        return failMap;
    }

    @Override
    public void dispose() {
        this.shutdown();
        try {
            this.writerThread.join(5000L);
            if (this.writerThread.isAlive()) {
                logger.warn("Writer thread is still alive after 5000ms");
            }
        }
        catch (InterruptedException e) {
            logger.warn("Failed to wait for end of writer", (Throwable)e);
        }
        try {
            this.mbs.unregisterMBean(this.name);
        }
        catch (Exception e) {
            logger.warn("Failed to unregister: " + this.name, (Throwable)e);
        }
    }

    private void shutdown() {
        try {
            this.writeLock.lock();
            this.disposed = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getQueueSize() {
        try {
            this.readLock.lock();
            int n = this.queueMap.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

