/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataStore;
import org.eclipse.scada.utils.osgi.FilterUtil;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DataNodeTracker {
    private final SingleServiceTracker<DataStore> tracker;
    private DataStore service;
    private final Map<String, Set<DataListener>> listeners = new HashMap<String, Set<DataListener>>();
    private static Filter FILTER;

    static {
        try {
            FILTER = FilterUtil.createClassFilter((String)DataStore.class.getName());
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public DataNodeTracker(BundleContext context) {
        this.tracker = new SingleServiceTracker(context, FILTER, (SingleServiceListener)new SingleServiceListener<DataStore>(){

            public void serviceChange(ServiceReference<DataStore> reference, DataStore service) {
                DataNodeTracker.this.handleService(service);
            }
        });
    }

    protected synchronized void handleService(DataStore service) {
        if (this.service != null) {
            for (Map.Entry<String, Set<DataListener>> listeners : this.listeners.entrySet()) {
                for (DataListener listener : listeners.getValue()) {
                    this.service.detachListener(listeners.getKey(), listener);
                }
            }
        }
        this.service = service;
        if (this.service != null) {
            for (Map.Entry<String, Set<DataListener>> listeners : this.listeners.entrySet()) {
                for (DataListener listener : listeners.getValue()) {
                    this.service.attachListener(listeners.getKey(), listener);
                }
            }
        }
    }

    public void open() {
        this.tracker.open();
    }

    public void close() {
        this.tracker.close();
    }

    public synchronized void addListener(String nodeId, DataListener listener) {
        Set<DataListener> set = this.listeners.get(nodeId);
        if (set == null) {
            set = new HashSet<DataListener>(1);
            this.listeners.put(nodeId, set);
        }
        if (set.add(listener) && this.service != null) {
            this.service.attachListener(nodeId, listener);
        }
    }

    public synchronized void removeListener(String nodeId, DataListener listener) {
        Set<DataListener> set = this.listeners.get(nodeId);
        if (set == null) {
            return;
        }
        if (set.remove(listener) && this.service != null) {
            this.service.detachListener(nodeId, listener);
        }
        if (set.isEmpty()) {
            this.listeners.remove(nodeId);
        }
    }

    public boolean write(DataNode node) {
        DataStore store = this.service;
        if (store != null) {
            store.writeNode(node);
            return true;
        }
        return false;
    }
}

