/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds.storage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.concurrent.Executor;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataStore;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorage
implements DataStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractStorage.class);
    private final Multimap<String, DataListener> listeners = HashMultimap.create();

    public abstract NotifyFuture<DataNode> readNode(String var1);

    protected abstract Executor getExecutor();

    public synchronized void dispose() {
        for (final DataListener listener : this.listeners.values()) {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.nodeChanged(null);
                }
            });
        }
        this.listeners.clear();
    }

    public synchronized void attachListener(String nodeId, final DataListener listener) {
        if (this.listeners.put((Object)nodeId, (Object)listener)) {
            final NotifyFuture<DataNode> task = this.readNode(nodeId);
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.nodeChanged((DataNode)task.get());
                    }
                    catch (Exception e) {
                        listener.nodeChanged(null);
                        logger.info("Failed to initially load data node", (Throwable)e);
                    }
                }
            });
        }
    }

    public synchronized void detachListener(String nodeId, DataListener listener) {
        this.listeners.remove((Object)nodeId, (Object)listener);
    }

    protected synchronized void fireUpdate(final DataNode node) {
        for (final DataListener listener : this.listeners.get((Object)node.getId())) {
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    listener.nodeChanged(node);
                }
            });
        }
    }
}

