/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec;

import org.eclipse.scada.sec.PermissionDeniedException;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.lang.Immutable;
import org.eclipse.scada.utils.statuscodes.CodedExceptionBase;
import org.eclipse.scada.utils.statuscodes.StatusCode;

@Immutable
public class AuthorizationResult {
    private final StatusCode errorCode;
    private final String message;
    public static final AuthorizationResult GRANTED = new AuthorizationResult();
    public static final AuthorizationResult ABSTAIN = null;

    public static AuthorizationResult createGranted() {
        return GRANTED;
    }

    public static AuthorizationResult createAbstain() {
        return ABSTAIN;
    }

    public static AuthorizationResult createReject(StatusCode statusCode, String message) {
        if (statusCode == null) {
            return AuthorizationResult.createGranted();
        }
        return new AuthorizationResult(statusCode, message);
    }

    public static AuthorizationResult createReject(Throwable error) {
        if (error == null) {
            return AuthorizationResult.createGranted();
        }
        if (error instanceof CodedExceptionBase) {
            return new AuthorizationResult(((CodedExceptionBase)error).getStatus(), error.getMessage());
        }
        return new AuthorizationResult(StatusCodes.UNKNOWN_STATUS_CODE, error.getMessage());
    }

    protected AuthorizationResult() {
        this.errorCode = null;
        this.message = null;
    }

    protected AuthorizationResult(StatusCode errorCode, String message) {
        this.errorCode = errorCode;
        this.message = message;
    }

    public boolean isGranted() {
        return this.errorCode == null && this.message == null;
    }

    public StatusCode getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public <T> NotifyFuture<T> asFuture() {
        PermissionDeniedException e = this.asException();
        if (e == null) {
            return null;
        }
        return new InstantErrorFuture(e.fillInStackTrace());
    }

    public PermissionDeniedException asException() {
        if (this.isGranted()) {
            return null;
        }
        return new PermissionDeniedException(this.errorCode, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        if (this.errorCode == null) {
            sb.append("GRANTED");
        } else {
            sb.append(String.format("%s: %s", this.errorCode, this.message));
        }
        sb.append("]");
        return sb.toString();
    }
}

