/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.controller;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.controller.AbstractMouseHandler;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class MouseDragZoomer
extends AbstractMouseHandler
implements Renderer {
    private final ChartRenderer chart;
    private final ChartMouseMoveListener mouseMoveListener;
    private Point start;
    private Rectangle selection;
    private final ChartMouseListener mouseListener;

    public MouseDragZoomer(ChartRenderer chart, IObservableList xAxis, IObservableList yAxis) {
        super(xAxis, yAxis);
        this.chart = chart;
        chart.addRenderer(this);
        this.mouseMoveListener = new ChartMouseMoveListener(){

            @Override
            public void onMouseMove(ChartMouseListener.MouseState state) {
                MouseDragZoomer.this.handleMouseMove(state);
            }
        };
        this.mouseListener = new ChartMouseListener(){

            @Override
            public void onMouseDoubleClick(ChartMouseListener.MouseState state) {
            }

            @Override
            public void onMouseDown(ChartMouseListener.MouseState state) {
                if (state.button == 1 && state.state == 0) {
                    MouseDragZoomer.this.startZoom(state);
                }
            }

            @Override
            public void onMouseUp(ChartMouseListener.MouseState state) {
                MouseDragZoomer.this.endZoom(state);
            }
        };
        chart.addMouseListener(this.mouseListener);
        chart.addDisposeListener(new DisposeListener(){

            @Override
            public void onDispose() {
                MouseDragZoomer.this.dispose();
            }
        });
    }

    private void detachMouseMoveListener() {
        this.chart.removeMouseMoveListener(this.mouseMoveListener);
    }

    public void dispose() {
        this.chart.removeMouseListener(this.mouseListener);
        this.chart.removeRenderer(this);
        this.detachMouseMoveListener();
    }

    protected void endZoom(ChartMouseListener.MouseState e) {
        this.processZoom(this.selection);
        this.detachMouseMoveListener();
        this.selection = null;
        this.chart.refresh();
    }

    protected void startZoom(ChartMouseListener.MouseState state) {
        this.chart.addMouseMoveListener(this.mouseMoveListener);
        Rectangle chartRect = this.chart.getClientAreaProxy().getClientRectangle();
        this.start = new Point(state.x - chartRect.x, state.y - chartRect.y);
    }

    protected void handleMouseMove(ChartMouseListener.MouseState state) {
        this.selection = this.makeSelection(new Point(state.x, state.y));
        this.chart.refresh();
    }

    private Rectangle makeSelection(Point point) {
        Rectangle chartRect = this.chart.getClientAreaProxy().getClientRectangle();
        return new Rectangle(this.start.x, this.start.y, point.x - chartRect.x - this.start.x, point.y - chartRect.y - this.start.y);
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        if (this.selection != null) {
            Rectangle chartRect = this.chart.getClientAreaProxy().getClientRectangle();
            g.setLineAttributes(new LineAttributes(1.0f));
            g.setForeground(null);
            g.drawRectangle(this.selection.x + chartRect.x, this.selection.y + chartRect.y, this.selection.width, this.selection.height);
        }
    }

    @Override
    public Rectangle resize(ResourceManager resourceManager, Rectangle clientRectangle) {
        return null;
    }

    private void processZoom(final Rectangle selection) {
        if (selection == null) {
            return;
        }
        final Rectangle client = this.chart.getClientAreaProxy().getClientRectangle();
        if (selection.width == 0 || selection.width == 0) {
            return;
        }
        this.chart.setStale(true);
        if (selection.width > 0 && selection.height > 0) {
            this.processX(new AbstractMouseHandler.AxisFunction<XAxis>(){

                @Override
                public void process(XAxis axis) {
                    long minTimestamp = axis.translateToValue(client.width, (float)selection.x);
                    long maxTimestamp = axis.translateToValue(client.width, (float)(selection.x + selection.width));
                    axis.setMinMax(minTimestamp, maxTimestamp);
                }
            });
            this.processY(new AbstractMouseHandler.AxisFunction<YAxis>(){

                @Override
                public void process(YAxis axis) {
                    double maxValue = axis.translateToValue(client.height, (float)selection.y);
                    double minValue = axis.translateToValue(client.height, (float)(selection.y + selection.height));
                    axis.setMinMax(minValue, maxValue);
                }
            });
        } else {
            final int widthSelection = Math.abs(selection.width);
            final int heightSelection = Math.abs(selection.height);
            final int widthClient = client.width;
            final int heightClient = client.height;
            this.processX(new AbstractMouseHandler.AxisFunction<XAxis>(){

                @Override
                public void process(XAxis axis) {
                    axis.zoom(1.0 + Math.abs((double)widthSelection) / (double)widthClient);
                }
            });
            this.processY(new AbstractMouseHandler.AxisFunction<YAxis>(){

                @Override
                public void process(YAxis axis) {
                    axis.zoom(1.0 + Math.abs((double)heightSelection) / (double)heightClient);
                }
            });
        }
        this.chart.setStale(false);
    }
}

