/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.swt.ChartMouseListener;
import org.eclipse.scada.chart.swt.ChartMouseMoveListener;
import org.eclipse.scada.chart.swt.DisposeListener;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public abstract class ChartRenderer {
    private final List<RendererEntry> renderers = new LinkedList<RendererEntry>();
    private boolean stale;
    private boolean updatePending;
    private boolean disposed;
    private final SizeRenderProxy clientAreaProxy;
    private Rectangle clientRectangle;
    private final Set<DisposeListener> disposeListeners = new LinkedHashSet<DisposeListener>();
    private RGB background;
    private final ResourceManager resourceManager;

    public ChartRenderer(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.clientAreaProxy = new SizeRenderProxy();
        this.renderers.add(new RendererEntry(this.clientAreaProxy, 0));
    }

    public void relayout() {
        if (this.stale) {
            this.updatePending = true;
            return;
        }
        Rectangle current = this.clientRectangle;
        for (RendererEntry renderer : this.renderers) {
            renderer.setBounds(current);
            Rectangle newBounds = renderer.getRenderer().resize(this.resourceManager, current);
            if (newBounds == null) continue;
            current = newBounds;
        }
    }

    public void resizeAll(Rectangle clientRectangle) {
        this.clientRectangle = clientRectangle;
        this.relayout();
    }

    protected void checkWidget() {
    }

    protected abstract void redraw();

    public abstract Rectangle getClientArea();

    public SizeRenderProxy getClientAreaProxy() {
        return this.clientAreaProxy;
    }

    public void paint(Graphics g) {
        g.setAntialias(true);
        if (this.background != null) {
            g.setBackground(this.background);
            g.fillRectangle(this.getClientArea());
        }
        for (RendererEntry renderer : this.renderers) {
            renderer.render(g);
        }
    }

    public void addRenderer(Renderer renderer) {
        this.addRenderer(renderer, 0);
    }

    public void addRenderer(Renderer renderer, int order) {
        this.checkWidget();
        this.renderers.add(new RendererEntry(renderer, order));
        Collections.sort(this.renderers, new Comparator<RendererEntry>(){

            @Override
            public int compare(RendererEntry o1, RendererEntry o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        this.resizeAll(this.getClientArea());
    }

    public void removeRenderer(Renderer renderer) {
        this.checkWidget();
        Iterator<RendererEntry> i = this.renderers.iterator();
        while (i.hasNext()) {
            RendererEntry entry = i.next();
            if (!entry.getRenderer().equals(renderer)) continue;
            i.remove();
        }
    }

    public void refresh() {
        this.checkWidget();
        if (this.stale) {
            this.updatePending = true;
        } else {
            this.redraw();
        }
    }

    public void setStale(boolean stale) {
        this.setStale(stale, false);
    }

    public void setStale(boolean stale, boolean forceUpdate) {
        this.checkWidget();
        this.stale = stale;
        if (!stale && (this.updatePending || forceUpdate)) {
            this.updatePending = false;
            this.relayout();
            this.redraw();
        }
    }

    public void dispose() {
        this.checkWidget();
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        for (final DisposeListener listener : this.disposeListeners) {
            SafeRunnable.getRunner().run((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    listener.onDispose();
                }
            });
        }
        this.resourceManager.dispose();
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        this.disposeListeners.add(disposeListener);
    }

    public abstract void addMouseListener(ChartMouseListener var1);

    public abstract void removeMouseListener(ChartMouseListener var1);

    public abstract void addMouseMoveListener(ChartMouseMoveListener var1);

    public abstract void removeMouseMoveListener(ChartMouseMoveListener var1);

    public abstract void addMouseWheelListener(MouseWheelListener var1);

    public abstract void removeMouseWheelListener(MouseWheelListener var1);

    public boolean isDisposed() {
        return this.disposed;
    }

    public abstract Realm getRealm();

    public void setChartBackground(RGB background) {
        this.background = background;
    }

    public RGB getChartBackground() {
        return this.background;
    }

    public void setFocus() {
    }

    public DropTarget createDropTarget(Transfer[] transfers, DropTargetAdapter createDropTarget) {
        return null;
    }

    private static class RendererEntry {
        private final Integer order;
        private final Renderer renderer;
        private Rectangle bounds;

        public RendererEntry(Renderer renderer, int order) {
            this.renderer = renderer;
            this.order = order;
        }

        public Integer getOrder() {
            return this.order;
        }

        public Renderer getRenderer() {
            return this.renderer;
        }

        public void setBounds(Rectangle bounds) {
            this.bounds = bounds;
        }

        public void render(Graphics g) {
            this.renderer.render(g, this.bounds);
        }
    }

    public static class SizeRenderProxy
    implements Renderer {
        private Rectangle clientRectangle;

        @Override
        public void render(Graphics g, Rectangle clientRectangle) {
        }

        @Override
        public Rectangle resize(ResourceManager resourceManager, Rectangle clientRectangle) {
            this.clientRectangle = clientRectangle;
            return null;
        }

        public Rectangle getClientRectangle() {
            return this.clientRectangle;
        }
    }
}

