/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.render;

import java.util.List;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.Graphics;
import org.eclipse.scada.chart.swt.Helper;
import org.eclipse.scada.chart.swt.render.AbstractRenderer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;

public class YAxisDynamicRenderer
extends AbstractRenderer {
    private YAxis axis;
    private RGB color;
    private boolean left;
    private Rectangle rect;
    private int width = -1;
    protected final LineAttributes lineAttributes;
    private int labelSpacing = 15;
    private final int markerSize = 8;
    private int textPadding = 10;
    private final ChartRenderer chart;
    private boolean showLabels = true;
    private String format;

    public YAxisDynamicRenderer(ChartRenderer chart) {
        super(chart);
        this.chart = chart;
        this.lineAttributes = new LineAttributes(1.0f, 1, 3, 1, new float[0], 0.0f, 0.0f);
    }

    public void setFormat(String format) {
        this.format = format;
        this.relayoutParent();
    }

    public String getFormat() {
        return this.format;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.relayoutParent();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    public void setLabelSpacing(int labelSpacing) {
        this.labelSpacing = labelSpacing;
        this.relayoutParent();
    }

    public void setWidth(int width) {
        this.width = width;
        this.relayoutParent();
    }

    public int getWidth() {
        return this.width;
    }

    public void setTextPadding(int textPadding) {
        this.textPadding = textPadding;
        this.relayoutParent();
    }

    public int getTextPadding() {
        return this.textPadding;
    }

    public void setAlign(int alignment) {
        this.left = (alignment & 0x20000) != 131072;
        this.relayoutParent();
    }

    public void setColor(RGB color) {
        this.color = color;
        this.redraw();
    }

    public RGB getColor() {
        return this.color;
    }

    public void setAxis(YAxis axis) {
        this.checkWidget();
        if (this.axis != null) {
            this.axis.removePropertyChangeListener(this.propertyChangeListener);
            this.axis = null;
        }
        this.axis = axis;
        if (this.axis != null) {
            this.axis.addPropertyChangeListener(this.propertyChangeListener);
        }
        this.relayoutParent();
    }

    @Override
    public void render(Graphics g, Rectangle clientRectangle) {
        List<Helper.Entry<Double>> markers;
        if (this.rect.width == 0 || this.rect.height == 0 || this.axis == null) {
            return;
        }
        Rectangle chartRect = this.chart.getClientAreaProxy().getClientRectangle();
        Rectangle clippingRect = new Rectangle(this.rect.x, this.rect.y - 10, this.rect.width, this.rect.height + 20);
        g.setClipping(clippingRect);
        g.setLineAttributes(this.lineAttributes);
        g.setForeground(this.color);
        g.setAntialias(true);
        int x = (this.left ? this.rect.width - 1 : 0) + this.rect.x;
        if (this.showLabels) {
            int fontHeight = g.getFontMetrics().getHeight();
            markers = Helper.chartValues(this.axis.getMin(), this.axis.getMax(), chartRect.height, fontHeight + this.labelSpacing);
            for (Helper.Entry entry : markers) {
                Point labelSize = g.textExtent(entry.label);
                int y = entry.position + this.rect.y;
                int tx = this.left ? x - (labelSize.x + this.textPadding + 8) : x + this.textPadding + 8;
                int ty = y - labelSize.y / 2;
                if (y < this.rect.y || y > this.rect.y + this.rect.height) continue;
                g.drawText(entry.label, tx, ty, null);
            }
        } else {
            markers = null;
        }
        String label = this.axis.getLabel();
        if (label != null) {
            Point point = g.textExtent(label);
            int tx = this.left ? this.rect.x + this.textPadding : this.rect.x + this.rect.width - (point.y + this.textPadding);
            int ty = this.rect.y + this.rect.height - this.rect.height / 2 + point.x / 2;
            g.drawText(label, -ty, tx, Float.valueOf(-90.0f));
        }
        g.setAntialias(false);
        if (this.showLabels) {
            for (Helper.Entry entry : markers) {
                int y = entry.position + this.rect.y;
                if (y < this.rect.y || y > this.rect.y + this.rect.height) continue;
                g.drawLine(x, y, x + (this.left ? -1 : 1) * 8, y);
            }
        }
        g.drawLine(x, this.rect.y, x, this.rect.y + this.rect.height + 1);
        g.setAntialias(true);
        g.setClipping(clientRectangle);
    }

    @Override
    public Rectangle resize(ResourceManager resourceManager, Rectangle clientRectangle) {
        int width;
        int n = width = this.width >= 0 ? this.width : this.calcWidth(resourceManager, clientRectangle.height);
        if (this.left) {
            this.rect = new Rectangle(clientRectangle.x, clientRectangle.y, width, clientRectangle.height);
            return new Rectangle(clientRectangle.x + width, clientRectangle.y, clientRectangle.width - width, clientRectangle.height);
        }
        this.rect = new Rectangle(clientRectangle.x + clientRectangle.width - width, clientRectangle.y, width, clientRectangle.height);
        return new Rectangle(clientRectangle.x, clientRectangle.y, clientRectangle.width - width, clientRectangle.height);
    }

    private int calcWidth(ResourceManager resourceManager, int height) {
        Point axisLabelSize;
        int maxTextWidth = 0;
        if (this.axis == null || this.axis.getMax() - this.axis.getMin() <= 0.0) {
            return 0;
        }
        GC gc = new GC((Drawable)resourceManager.getDevice());
        try {
            axisLabelSize = this.axis.getLabel() != null && !this.axis.getLabel().isEmpty() ? gc.textExtent(this.axis.getLabel()) : new Point(0, 0);
            if (this.showLabels) {
                int fontHeight = gc.getFontMetrics().getHeight();
                List<Helper.Entry<Double>> markers = Helper.chartValues(this.axis.getMin(), this.axis.getMax(), height, fontHeight + this.labelSpacing);
                for (Helper.Entry<Double> marker : markers) {
                    Point sampleLabelSize = gc.textExtent(marker.label);
                    maxTextWidth = Math.max(maxTextWidth, sampleLabelSize.x);
                }
            }
        }
        finally {
            gc.dispose();
        }
        return maxTextWidth + (this.showLabels ? 2 * this.textPadding + 8 : 0) + axisLabelSize.y + this.textPadding + 1;
    }
}

