/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scada.chart.AbstractFunctionSeriesData;
import org.eclipse.scada.chart.Realm;
import org.eclipse.scada.chart.SeriesViewData;
import org.eclipse.scada.chart.WritableSeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.utils.concurrent.ExportedExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncFunctionSeriesData
extends AbstractFunctionSeriesData {
    private static final Logger logger = LoggerFactory.getLogger(AsyncFunctionSeriesData.class);
    private final ExecutorService executor;
    private WritableSeriesData data;
    private AbstractFunctionSeriesData.Request nextRequest;
    private final int sleep;
    private static final AtomicLong COUNTER = new AtomicLong();

    public AsyncFunctionSeriesData(Realm realm, XAxis xAxis, YAxis yAxis, int sleep) {
        super(realm, xAxis, yAxis);
        this.sleep = sleep;
        this.executor = ExportedExecutorService.newSingleThreadExportedExecutor((String)("AsyncFunctionSeriesData/" + COUNTER.incrementAndGet()));
        this.data = new WritableSeriesData();
        this.setRequest(new AbstractFunctionSeriesData.Request(xAxis.getMin(), xAxis.getMax(), 1));
    }

    @Override
    public SeriesViewData getViewData() {
        return this.data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setRequest(AbstractFunctionSeriesData.Request request) {
        boolean start;
        super.setRequest(request);
        AsyncFunctionSeriesData asyncFunctionSeriesData = this;
        synchronized (asyncFunctionSeriesData) {
            start = this.nextRequest == null;
            this.nextRequest = request;
        }
        if (start) {
            logger.debug("Starting request by: {}", (Object)request);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    AsyncFunctionSeriesData.this.generateData();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateData() {
        AbstractFunctionSeriesData.Request request;
        AsyncFunctionSeriesData asyncFunctionSeriesData = this;
        synchronized (asyncFunctionSeriesData) {
            request = this.nextRequest;
            this.nextRequest = null;
        }
        logger.debug("Processing request: {}", (Object)request);
        this.setData(this.makeData(request));
    }

    protected void setData(WritableSeriesData data) {
        if (this.sleep > 0) {
            try {
                Thread.sleep(this.sleep);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.data = data;
        this.fireUpdateListener(data.getMinTimestamp(), data.getMaxTimestamp());
    }

    @Override
    protected abstract Double eval(long var1);

    public void regenerate() {
        logger.debug("Regenerate: {}", (Object)this.request);
        this.setRequest(this.request);
    }
}

