/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.chart.swt.manager;

import org.eclipse.scada.chart.SeriesData;
import org.eclipse.scada.chart.XAxis;
import org.eclipse.scada.chart.YAxis;
import org.eclipse.scada.chart.swt.ChartArea;
import org.eclipse.scada.chart.swt.ChartRenderer;
import org.eclipse.scada.chart.swt.render.Renderer;
import org.eclipse.scada.chart.swt.render.StepRenderer;
import org.eclipse.scada.chart.swt.render.XAxisDynamicRenderer;
import org.eclipse.scada.chart.swt.render.YAxisDynamicRenderer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChartManager
extends Composite {
    private final ChartArea chartArea;
    private final Label title;

    public ChartManager(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)ChartManager.makeLayout());
        this.title = new Label((Composite)this, 0);
        this.title.setLayoutData((Object)new GridData(2, 4, true, false, 1, 1));
        this.chartArea = new ChartArea(this, 0);
        this.chartArea.setLayoutData(this.makeMainLayoutData());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChartManager.this.onDispose();
            }
        });
    }

    private static GridLayout makeLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        return layout;
    }

    private Object makeMainLayoutData() {
        return new GridData(4, 4, true, true);
    }

    protected void onDispose() {
    }

    public ChartArea getChartArea() {
        return this.chartArea;
    }

    public ChartRenderer getChartRenderer() {
        return this.chartArea.getChartRenderer();
    }

    public void setChartBackground(Color color) {
        this.checkWidget();
        this.chartArea.setBackground(color);
    }

    public XAxisDynamicRenderer addDynamicXAxis(XAxis x, boolean top) {
        this.checkWidget();
        XAxisDynamicRenderer renderer = new XAxisDynamicRenderer(this.chartArea.getChartRenderer());
        renderer.setAxis(x);
        renderer.setAlign(top ? 128 : 1024);
        this.addRenderer(renderer, -2);
        return renderer;
    }

    public YAxisDynamicRenderer addDynamicYAxis(YAxis y, boolean left) {
        this.checkWidget();
        YAxisDynamicRenderer renderer = new YAxisDynamicRenderer(this.chartArea.getChartRenderer());
        renderer.setAxis(y);
        renderer.setAlign(left ? 16384 : 131072);
        this.addRenderer(renderer, -1);
        return renderer;
    }

    public StepRenderer createStepSeries(SeriesData abstractSeriesData) {
        this.checkWidget();
        StepRenderer renderer = new StepRenderer(this.chartArea.getChartRenderer(), abstractSeriesData);
        this.addRenderer(renderer, 0);
        return renderer;
    }

    public void setTitle(String title) {
        this.checkWidget();
        this.title.setText(title);
        this.title.pack();
        this.layout();
    }

    public String getTitle() {
        this.checkWidget();
        return this.title.getText();
    }

    public DropTarget createDropTarget(Transfer[] transfers, DropTargetListener dropTargetListener) {
        this.checkWidget();
        DropTarget target = new DropTarget((Control)this.chartArea, 21);
        target.setTransfer(transfers);
        target.addDropListener(dropTargetListener);
        return target;
    }

    public void addRenderer(Renderer renderer, int order) {
        this.checkWidget();
        this.chartArea.getChartRenderer().addRenderer(renderer, order);
    }

    public void removeRenderer(Renderer renderer) {
        this.checkWidget();
        this.chartArea.getChartRenderer().removeRenderer(renderer);
    }
}

