/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.navigator;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.scada.ae.ui.testing.navigator.QueryBean;
import org.eclipse.scada.ae.ui.testing.navigator.QueryListWrapper;
import org.eclipse.scada.ui.databinding.CommonListeningLabelProvider;
import org.eclipse.scada.ui.databinding.StyledViewerLabel;

public class LabelProvider
extends CommonListeningLabelProvider
implements PropertyChangeListener {
    private final ResourceManager resource = new LocalResourceManager(JFaceResources.getResources());

    public LabelProvider() {
        super("org.eclipse.scada.ae.ui.testing.query.contentExtension");
    }

    public void dispose() {
        this.resource.dispose();
        super.dispose();
    }

    public void updateLabel(StyledViewerLabel label, Object element) {
        if (element instanceof QueryListWrapper) {
            label.setText("Test Queries");
        } else if (element instanceof QueryBean) {
            QueryBean query = (QueryBean)((Object)element);
            StyledString text = new StyledString();
            text.append(String.format("%.20s:%.40s", query.getFilterType(), query.getFilterData()));
            text.append(" ");
            text.append(String.format("%s", query.getCount()), StyledString.COUNTER_STYLER);
            text.append(" ");
            text.append(String.format("[%s]", query.getState()), StyledString.DECORATIONS_STYLER);
            label.setStyledText(text);
            label.setTooltipText(String.format("%s%n%s", query.getFilterType(), query.getFilterData()));
        } else {
            super.updateLabel(label, element);
        }
    }

    protected void addListenerTo(Object next) {
        super.addListenerTo(next);
        if (next instanceof QueryBean) {
            ((QueryBean)((Object)next)).addPropertyChangeListener(this);
        }
    }

    protected void removeListenerFrom(Object next) {
        if (next instanceof QueryBean) {
            ((QueryBean)((Object)next)).removePropertyChangeListener(this);
        }
        super.removeListenerFrom(next);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireChangeEvent(Arrays.asList(evt.getSource()));
    }
}

