/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.ui.testing.views;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scada.ae.Event;
import org.eclipse.scada.core.Variant;

public class EventsLabelProvider
extends CellLabelProvider {
    private final IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            if (!affectedElements.isEmpty()) {
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)EventsLabelProvider.this, affectedElements.toArray());
                EventsLabelProvider.this.fireLabelProviderChanged(newEvent);
            }
        }
    };
    private final IObservableMap[] attributeMaps;
    private final DateFormat dateFormat;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public EventsLabelProvider(IObservableMap ... attributeMaps) {
        int i = 0;
        while (i < attributeMaps.length) {
            attributeMaps[i].addMapChangeListener(this.mapChangeListener);
            ++i;
        }
        this.attributeMaps = attributeMaps;
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    }

    public void dispose() {
        int i = 0;
        while (i < this.attributeMaps.length) {
            this.attributeMaps[i].removeMapChangeListener(this.mapChangeListener);
            ++i;
        }
        super.dispose();
        this.resourceManager.dispose();
    }

    private Variant getAttributes(Event event, String key) {
        return this.getAttributes(event, key, Variant.NULL);
    }

    private Variant getAttributes(Event event, String key, Variant defaultValue) {
        Variant value = (Variant)event.getAttributes().get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public void update(ViewerCell cell) {
        Object o = cell.getElement();
        if (o instanceof Event) {
            Event info = (Event)o;
            switch (cell.getColumnIndex()) {
                case 0: {
                    cell.setText(this.dateFormat.format(info.getSourceTimestamp()));
                    break;
                }
                case 1: {
                    cell.setText(this.dateFormat.format(info.getEntryTimestamp()));
                    break;
                }
                case 2: {
                    cell.setText(this.getAttributes(info, Event.Fields.SOURCE.getName()).asString(""));
                    break;
                }
                case 3: {
                    cell.setText(this.getAttributes(info, Event.Fields.MONITOR_TYPE.getName()).asString(""));
                    break;
                }
                case 4: {
                    cell.setText(this.getAttributes(info, Event.Fields.EVENT_TYPE.getName()).asString(""));
                    break;
                }
                case 5: {
                    cell.setText(this.getAttributes(info, Event.Fields.ACTOR_NAME.getName()).asString(""));
                    break;
                }
                case 6: {
                    cell.setText(this.getAttributes(info, Event.Fields.VALUE.getName()).asString(""));
                    break;
                }
                case 7: {
                    cell.setText(this.getAttributes(info, Event.Fields.MESSAGE.getName()).asString(""));
                }
            }
        }
    }
}

