/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authn.osgi.cfg.priority;

import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.scada.sec.AuthenticationException;
import org.eclipse.scada.sec.AuthenticationImplementation;
import org.eclipse.scada.sec.AuthenticationService;
import org.eclipse.scada.sec.StatusCodes;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.sec.authn.CredentialsRequest;
import org.eclipse.scada.sec.authn.osgi.cfg.priority.Configuration;
import org.eclipse.scada.sec.authn.osgi.cfg.priority.ConfigurationGroup;
import org.eclipse.scada.sec.authn.osgi.cfg.priority.ConfigurationManagerImpl;
import org.eclipse.scada.sec.authn.osgi.cfg.priority.ProcessCallbacksFuture;
import org.eclipse.scada.sec.callback.Callback;
import org.eclipse.scada.sec.callback.CallbackHandler;
import org.eclipse.scada.sec.callback.Callbacks;
import org.eclipse.scada.utils.concurrent.InstantErrorFuture;
import org.eclipse.scada.utils.concurrent.IteratingFuture;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Authenticator
implements AuthenticationImplementation {
    private static final Logger logger = LoggerFactory.getLogger(Authenticator.class);
    private ConfigurationManagerImpl manager;

    public void activate(BundleContext context) {
        this.manager = new ConfigurationManagerImpl(context);
    }

    public void deactivate() {
        this.manager.dispose();
    }

    public UserInformation getUser(String user) {
        logger.debug("Getting user information - {}", (Object)user);
        Configuration cfg = this.manager.getConfiguration();
        for (ConfigurationGroup group : cfg.getGroups()) {
            for (AuthenticationService service : group.getServices()) {
                UserInformation result = service.getUser(user);
                if (result == null) continue;
                logger.debug("Found user information from service - service: {}, user: {}", (Object)service, (Object)result);
                return result;
            }
        }
        logger.debug("None found");
        return null;
    }

    public NotifyFuture<UserInformation> authenticate(CallbackHandler callbackHandler) {
        Configuration configuration;
        logger.debug("Start authenticating - callbackHandler: {}", (Object)callbackHandler);
        try {
            configuration = this.manager.getConfiguration();
            if (configuration == null) {
                return new InstantErrorFuture((Throwable)new AuthenticationException(StatusCodes.AUTHENTICATION_FAILED, "No authentication configuration available"));
            }
        }
        catch (Exception e) {
            return new InstantErrorFuture((Throwable)new AuthenticationException(StatusCodes.AUTHENTICATION_FAILED, (Throwable)e));
        }
        return new GroupIteratorFuture(configuration.getGroups(), callbackHandler).startIterating();
    }

    protected NotifyFuture<UserInformation> authenticate(CallbackHandler callbackHandler, final ConfigurationGroup group) {
        final CredentialsRequest request = new CredentialsRequest();
        for (AuthenticationService service : group.getServices()) {
            logger.debug("Let service join: {}", (Object)service);
            service.joinRequest(request);
        }
        NotifyFuture future = Callbacks.callback((CallbackHandler)callbackHandler, (Callback[])request.buildCallbacks());
        return new ProcessCallbacksFuture(future){

            @Override
            protected CredentialsRequest getRequest() {
                return request;
            }

            @Override
            protected List<AuthenticationService> getServices() {
                return group.getServices();
            }
        };
    }

    private final class GroupIteratorFuture
    extends IteratingFuture<UserInformation, ConfigurationGroup> {
        private final CallbackHandler callbackHandler;
        private int counter;

        public GroupIteratorFuture(Iterable<ConfigurationGroup> iterable, CallbackHandler callbackHandler) {
            super(iterable);
            this.counter = 1;
            this.callbackHandler = callbackHandler;
        }

        protected void handleComplete(Future<UserInformation> future, ConfigurationGroup group) throws Exception {
            logger.debug("Handle complete - future: {}, group: {}", future, (Object)group);
            UserInformation userInformation = future.get();
            if (userInformation != null) {
                this.setResult(userInformation);
            } else if (this.counter < group.getRetries()) {
                logger.debug("Retry current group - retry #{} of {}", (Object)this.counter, (Object)group.getRetries());
                ++this.counter;
                this.processCurrent();
            } else {
                logger.debug("Try next authorization group");
                this.counter = 1;
                this.processNext();
            }
        }

        protected NotifyFuture<UserInformation> perform(ConfigurationGroup group) {
            logger.debug("Process group: {}", (Object)group);
            return Authenticator.this.authenticate(this.callbackHandler, group);
        }

        protected NotifyFuture<UserInformation> last() {
            return new InstantErrorFuture((Throwable)new AuthenticationException(StatusCodes.INVALID_USER_OR_PASSWORD));
        }
    }
}

