/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import java.util.Map;
import org.eclipse.scada.sec.callback.LabelCallback;

public class ConfirmationCallback
extends LabelCallback {
    public static final String TYPE = "confirm";
    private static final String PROP_CONFIRMATION_TYPE = "confirmationType";
    public static final String PROP_VALUE = "value";
    private Boolean value;
    private ConfirmationType confirmationType;

    public ConfirmationCallback() {
    }

    public ConfirmationCallback(ConfirmationType type, String label, int order) {
        super(label, order);
        this.confirmationType = type == null ? ConfirmationType.CONFIRM : type;
    }

    public ConfirmationType getConfirmationType() {
        return this.confirmationType;
    }

    public void setConfirmationType(ConfirmationType confirmationType) {
        this.confirmationType = confirmationType;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }

    public Boolean getValue() {
        return this.value;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void parseRequestAttributes(Map<String, String> attributes) {
        super.parseRequestAttributes(attributes);
        this.confirmationType = ConfirmationType.valueOf(attributes.get(PROP_CONFIRMATION_TYPE));
    }

    @Override
    protected void injectRequestAttributes(Map<String, String> request) {
        super.injectRequestAttributes(request);
        request.put(PROP_CONFIRMATION_TYPE, this.confirmationType.name());
    }

    @Override
    public void parseResponseAttributes(Map<String, String> attributes) {
        String result = attributes.get(PROP_VALUE);
        this.value = result != null ? Boolean.valueOf(Boolean.parseBoolean(result)) : null;
    }

    @Override
    protected void injectResponseAttributes(Map<String, String> result) {
        super.injectResponseAttributes(result);
        if (this.value != null) {
            result.put(PROP_VALUE, "" + this.value);
        }
    }

    public static enum ConfirmationType {
        INFORMATION,
        WARNING,
        ERROR,
        CONFIRM,
        QUESTION,
        QUESTION_WITH_CANCEL;

    }
}

