/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.callback;

import java.util.Map;
import org.eclipse.scada.sec.callback.AbstractCallback;

public class XMLSignatureCallback
extends AbstractCallback {
    public static final String TYPE = "xmlsignature";
    public static final String PROP_DOCUMENT = "document";
    public static final String PROP_SIGNED_DOCUMENT = "signedDocument";
    public static final String PROP_MAXIMUM_REMEMBER_PERIOD = "maximumRememberPeriod";
    private String document;
    private String signedDocument;
    private int maximumRememberPeriod = Integer.getInteger("org.eclipse.scada.sec.callback.XMLSignatureCallback.maxKeepKeyOpenTimeout", 300000);

    public XMLSignatureCallback() {
    }

    public XMLSignatureCallback(String document) {
        this.document = document;
    }

    public String getDocument() {
        return this.document;
    }

    public String getSignedDocument() {
        return this.signedDocument;
    }

    public void setSignedDocument(String signedDocument) {
        this.signedDocument = signedDocument;
    }

    public void setDocument(String document) {
        this.document = document;
    }

    @Override
    protected void injectRequestAttributes(Map<String, String> request) {
        super.injectRequestAttributes(request);
        request.put(PROP_DOCUMENT, this.document);
        request.put(PROP_MAXIMUM_REMEMBER_PERIOD, "" + this.maximumRememberPeriod);
    }

    @Override
    public void parseRequestAttributes(Map<String, String> attributes) {
        super.parseRequestAttributes(attributes);
        this.document = attributes.get(PROP_DOCUMENT);
        this.maximumRememberPeriod = this.parseInteger(attributes, PROP_MAXIMUM_REMEMBER_PERIOD, 300000);
    }

    @Override
    protected void injectResponseAttributes(Map<String, String> response) {
        super.injectResponseAttributes(response);
        if (this.signedDocument != null) {
            response.put(PROP_SIGNED_DOCUMENT, this.signedDocument);
        }
    }

    @Override
    public void parseResponseAttributes(Map<String, String> attributes) {
        super.parseResponseAttributes(attributes);
        this.signedDocument = attributes.get(PROP_SIGNED_DOCUMENT);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setMaximumRememberPeriod(int maximumRememberPeriod) {
        this.maximumRememberPeriod = maximumRememberPeriod;
    }

    public int getMaximumRememberPeriod() {
        return this.maximumRememberPeriod;
    }
}

