/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.datasource.constant;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.eclipse.scada.ca.common.factory.AbstractServiceConfigurationFactory;
import org.eclipse.scada.da.datasource.DataSource;
import org.eclipse.scada.da.datasource.constant.ConstantDataSource;
import org.eclipse.scada.sec.UserInformation;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolHelper;
import org.eclipse.scada.utils.osgi.pool.ObjectPoolImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ConstantDataSourceFactory
extends AbstractServiceConfigurationFactory<ConstantDataSource> {
    private final ExecutorService executor;
    private final ObjectPoolImpl<DataSource> objectPool;
    private final ServiceRegistration<?> poolRegistration;

    public ConstantDataSourceFactory(BundleContext context, ExecutorService executor) {
        super(context);
        this.executor = executor;
        this.objectPool = new ObjectPoolImpl();
        this.poolRegistration = ObjectPoolHelper.registerObjectPool((BundleContext)context, this.objectPool, DataSource.class);
    }

    public synchronized void dispose() {
        this.poolRegistration.unregister();
        this.objectPool.dispose();
        super.dispose();
    }

    protected AbstractServiceConfigurationFactory.Entry<ConstantDataSource> createService(UserInformation userInformation, String configurationId, BundleContext context, Map<String, String> parameters) throws Exception {
        ConstantDataSource service = new ConstantDataSource(this.executor);
        service.update(parameters);
        this.objectPool.addService(configurationId, (Object)service, null);
        return new AbstractServiceConfigurationFactory.Entry(configurationId, (Object)service);
    }

    protected void disposeService(UserInformation userInformation, String configurationId, ConstantDataSource service) {
        this.objectPool.removeService(configurationId, (Object)service);
    }

    protected AbstractServiceConfigurationFactory.Entry<ConstantDataSource> updateService(UserInformation userInformation, String configurationId, AbstractServiceConfigurationFactory.Entry<ConstantDataSource> entry, Map<String, String> parameters) throws Exception {
        ((ConstantDataSource)((Object)entry.getService())).update(parameters);
        return null;
    }
}

