/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolEncoder;
import org.apache.mina.transport.socket.SocketAcceptor;
import org.apache.mina.transport.socket.nio.NioSession;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.exporter.ObjectExporter;
import org.eclipse.scada.da.server.common.item.factory.ItemFactory;
import org.eclipse.scada.da.server.common.osgi.factory.ObjectPoolDataItemFactory;
import org.eclipse.scada.da.server.exporter.common.HiveSource;
import org.eclipse.scada.da.server.exporter.modbus.InformationBean;
import org.eclipse.scada.da.server.exporter.modbus.io.AbstractSourceType;
import org.eclipse.scada.da.server.exporter.modbus.io.DoubleType;
import org.eclipse.scada.da.server.exporter.modbus.io.MemoryBlock;
import org.eclipse.scada.da.server.exporter.modbus.io.ShortType;
import org.eclipse.scada.da.server.exporter.modbus.io.SourceDefinition;
import org.eclipse.scada.da.server.exporter.modbus.io.UnsignedShortType;
import org.eclipse.scada.protocol.modbus.codec.ModbusSlaveProtocolFilter;
import org.eclipse.scada.protocol.modbus.codec.ModbusTcpDecoder;
import org.eclipse.scada.protocol.modbus.codec.ModbusTcpEncoder;
import org.eclipse.scada.protocol.modbus.message.BaseMessage;
import org.eclipse.scada.protocol.modbus.message.ErrorResponse;
import org.eclipse.scada.protocol.modbus.message.ReadRequest;
import org.eclipse.scada.protocol.modbus.message.ReadResponse;
import org.eclipse.scada.utils.osgi.pool.ManageableObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusExport {
    private static final Logger logger = LoggerFactory.getLogger(ModbusExport.class);
    private MemoryBlock block;
    private final ScheduledExecutorService executor;
    private Properties properties;
    private final HiveSource hiveSource;
    private final IoProcessor<NioSession> processor;
    private SocketAcceptor acceptor;
    private SocketAddress currentAddress;
    private int slaveId;
    private Integer readTimeout;
    private final InformationBean info = new InformationBean();
    private ObjectExporter exporter;

    public ModbusExport(String id, ScheduledExecutorService executor, IoProcessor<NioSession> processor, HiveSource hiveSource, ManageableObjectPool<DataItem> itemObjectPool) {
        this.executor = executor;
        this.hiveSource = hiveSource;
        this.processor = processor;
        ObjectPoolDataItemFactory itemFactory = new ObjectPoolDataItemFactory((Executor)executor, itemObjectPool, String.format("org.eclipse.scada.da.server.exporter.modbus.export.%s.information.", id));
        this.exporter = new ObjectExporter((ItemFactory)itemFactory, true, true);
        this.exporter.attachTarget((Object)this.info);
    }

    public void dispose() {
        logger.debug("Disposing");
        if (this.exporter != null) {
            this.exporter.dispose();
            this.exporter = null;
        }
        this.disposeAcceptor();
        if (this.block != null) {
            this.block.dispose();
            this.block = null;
        }
    }

    private void disposeAcceptor() {
        if (this.acceptor != null) {
            this.acceptor.dispose(!Boolean.getBoolean("org.eclipse.scada.da.server.exporter.modbus.dontWaitDispose"));
            this.acceptor = null;
        }
    }

    private void createAcceptor() {
        NioSocketAcceptor acceptor = new NioSocketAcceptor(this.processor);
        try {
            acceptor.setReuseAddress(true);
            acceptor.setBacklog(Integer.getInteger("org.eclipse.scada.da.server.exporter.modbus.acceptor.backlog", 5).intValue());
            ModbusTcpEncoder encoder = new ModbusTcpEncoder();
            ModbusTcpDecoder decoder = new ModbusTcpDecoder();
            acceptor.getFilterChain().addLast("modbusPdu", (IoFilter)new ProtocolCodecFilter((ProtocolEncoder)encoder, (ProtocolDecoder)decoder));
            acceptor.getFilterChain().addLast("modbus", (IoFilter)new ModbusSlaveProtocolFilter());
            acceptor.setHandler((IoHandler)new IoHandlerAdapter(){

                public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                    session.close(true);
                }

                public void sessionOpened(IoSession session) throws Exception {
                    logger.info("Session opened: {}", (Object)session);
                    ModbusExport.this.info.incrementActiveSessions();
                    ModbusExport.this.handleSessionOpened(session);
                }

                public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
                    logger.info("Session idle: {}", (Object)session);
                    ModbusExport.this.handleSessionIdle(session);
                }

                public void sessionClosed(IoSession session) throws Exception {
                    logger.info("Session closed: {}", (Object)session);
                    ModbusExport.this.info.decrementActiveSessions();
                }

                public void messageReceived(IoSession session, Object message) throws Exception {
                    ModbusExport.this.handleMessageReceived(session, message);
                }
            });
            this.acceptor = acceptor;
            this.acceptor.bind(this.currentAddress);
        }
        catch (Exception e) {
            logger.warn("Failed to create acceptor", (Throwable)e);
            this.acceptor.dispose();
            throw new RuntimeException(e);
        }
    }

    public void update(Map<String, String> parameters) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(parameters);
        this.setReadTimeout(cfg.getInteger("timeout", 10000));
        this.setPort(cfg.getInteger("port", 502));
        this.setSlaveId(cfg.getInteger("slaveId", 1));
        this.setProperties(cfg.getPrefixedProperties("hive."));
        this.configureDefinitions(cfg);
    }

    private void setReadTimeout(Integer readTimeout) {
        this.readTimeout = readTimeout;
    }

    private void setSlaveId(int slaveId) {
        logger.debug("Setting slave id: {}", (Object)slaveId);
        this.slaveId = slaveId;
    }

    private void setPort(int port) throws IOException {
        InetSocketAddress address = new InetSocketAddress(port);
        if (this.currentAddress == null || !this.currentAddress.equals(address)) {
            logger.info("Rebinding interface - {} to {}", (Object)this.currentAddress, (Object)address);
            this.disposeAcceptor();
            this.currentAddress = address;
            this.createAcceptor();
        }
    }

    private void configureDefinitions(ConfigurationDataHelper cfg) {
        LinkedList<SourceDefinition> defs = new LinkedList<SourceDefinition>();
        for (Map.Entry entry : cfg.getPrefixed("item.").entrySet()) {
            String itemId = (String)entry.getKey();
            String[] args = ((String)entry.getValue()).split(":");
            logger.info("Adding - itemId: {}, arguments: {}", (Object)itemId, (Object)args);
            defs.add(this.convert(itemId, args));
        }
        this.block.setConfiguration(defs);
    }

    private SourceDefinition convert(String itemId, String[] args) {
        AbstractSourceType type;
        int offset = Integer.parseInt(args[0]);
        switch (args[1].toUpperCase()) {
            case "DOUBLE": {
                type = new DoubleType(this.getFactor(args));
                break;
            }
            case "INT16": 
            case "SHORT": {
                type = new ShortType(this.getFactor(args));
                break;
            }
            case "UINT16": 
            case "WORD": {
                type = new UnsignedShortType(this.getFactor(args));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Type '%s' is unknown.", args[1]));
            }
        }
        return new SourceDefinition(itemId, offset * 2, type);
    }

    private Double getFactor(String[] args) {
        if (args.length > 2) {
            return Double.parseDouble(args[2]);
        }
        return null;
    }

    private void setProperties(Properties properties) {
        if (this.block == null) {
            logger.debug("Create new block");
            this.block = new MemoryBlock(this.executor, this.hiveSource, properties);
        } else if (!this.properties.equals(properties)) {
            logger.debug("Re-create block");
            this.block.dispose();
            this.block = null;
            this.block = new MemoryBlock(this.executor, this.hiveSource, properties);
        }
        this.properties = properties;
    }

    protected void handleSessionOpened(IoSession session) {
        Integer idle = this.readTimeout;
        if (idle != null) {
            if ((idle = Integer.valueOf(idle / 1000)) < 0) {
                idle = 1;
            }
            logger.debug("Setting read idle timeout: {} second(s)", (Object)idle);
            session.getConfig().setIdleTime(IdleStatus.READER_IDLE, idle.intValue());
        }
    }

    protected void handleSessionIdle(IoSession session) {
        logger.info("Closing session due to reader timeout");
        session.close(true);
    }

    protected void handleMessageReceived(IoSession session, Object message) {
        logger.trace("New message - message: {}, session: {}", message, (Object)session);
        this.info.incrementMessagesReceived();
        if (!(message instanceof BaseMessage)) {
            return;
        }
        BaseMessage baseMessage = (BaseMessage)message;
        if (baseMessage.getUnitIdentifier() != this.slaveId) {
            logger.trace("Invalid unit id - use: {}, them: {}", (Object)this.slaveId, (Object)baseMessage.getUnitIdentifier());
            return;
        }
        if (message instanceof ReadRequest) {
            this.info.incrementReadRequestReceived();
            this.handleRead(session, (ReadRequest)message);
        }
    }

    private void handleRead(IoSession session, ReadRequest message) {
        switch (message.getFunctionCode()) {
            case 3: {
                this.info.incrementReadHoldingRequestReceived();
                this.readHoldingData(session, message);
                break;
            }
            default: {
                logger.info("Function code {} is not implemented", (Object)message.getFunctionCode());
                this.sendReply(session, this.makeError((BaseMessage)message, 1));
            }
        }
    }

    protected void readHoldingData(IoSession session, ReadRequest message) {
        int byteOffset = message.getStartAddress() * 2;
        int byteLength = message.getQuantity() * 2;
        logger.debug("Reading - byteOffset: {}, byteLength: {}", (Object)byteOffset, (Object)byteLength);
        if (message.getQuantity() < 0 || message.getQuantity() >= 125) {
            logger.debug("Invalid quanity");
            this.sendReply(session, this.makeError((BaseMessage)message, 2));
            return;
        }
        IoBuffer data = this.block.readData(byteOffset, byteLength);
        if (data == null) {
            logger.debug("No data");
            this.sendReply(session, this.makeError((BaseMessage)message, 4));
        } else {
            this.sendReply(session, this.makeData((BaseMessage)message, data));
        }
    }

    protected Object makeData(BaseMessage message, IoBuffer data) {
        data.flip();
        logger.trace("Create data message - data: {}", (Object)data);
        return new ReadResponse(message.getTransactionId(), message.getUnitIdentifier(), message.getFunctionCode(), data);
    }

    protected ErrorResponse makeError(BaseMessage message, int exceptionCode) {
        this.info.incrementErrorReplies();
        byte functionCode = message.getFunctionCode();
        functionCode = (byte)(functionCode | 0xFFFFFF80);
        return new ErrorResponse(message.getTransactionId(), message.getUnitIdentifier(), functionCode, (byte)exceptionCode);
    }

    protected void sendReply(IoSession session, Object message) {
        logger.trace("Send reply - message: {}, session: {}", message, (Object)session);
        session.write(message);
    }
}

