/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.exporter.modbus.io;

import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.exporter.modbus.io.AbstractSourceType;

public class DoubleType
extends AbstractSourceType {
    private static final int DATA_LENGTH = 8;
    public static final int LENGTH = 18;
    private final Double factor;

    public DoubleType() {
        this(null);
    }

    public DoubleType(Double factor) {
        super(8);
        this.factor = factor;
    }

    @Override
    public void putValue(IoBuffer slice, Variant value) {
        slice.putDouble(this.makeValue(value));
    }

    private double makeValue(Variant value) {
        if (value == null) {
            return Double.NaN;
        }
        Double v = value.asDouble(null);
        if (v == null) {
            return Double.NaN;
        }
        if (this.factor != null) {
            return this.factor * v;
        }
        return v;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.factor == null ? 0 : this.factor.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DoubleType)) {
            return false;
        }
        DoubleType other = (DoubleType)obj;
        return !(this.factor == null ? other.factor != null : !this.factor.equals(other.factor));
    }
}

