/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.common.AttributeMode;
import org.eclipse.scada.da.server.common.chain.DataItemInputChained;
import org.eclipse.scada.da.server.jdbc.AbstractQuery;
import org.eclipse.scada.da.server.jdbc.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query
extends AbstractQuery {
    private static final Logger logger = LoggerFactory.getLogger(Query.class);
    private final Map<String, DataItemInputChained> items = new HashMap<String, DataItemInputChained>();

    public Query(String id, int period, String sql, Connection connection, Map<Integer, String> columnAliases) {
        super(id, period, sql, connection, columnAliases);
    }

    @Override
    protected void setGlobalError(Throwable e) {
        logger.error("Failed to query", e);
        for (Map.Entry<String, DataItemInputChained> entry : this.items.entrySet()) {
            this.setError(entry.getKey(), e);
        }
    }

    @Override
    protected void doQuery() throws Exception {
        logger.debug("Perform query");
        Throwable throwable = null;
        Object var2_3 = null;
        try (java.sql.Connection connection = this.connection.getConnection();){
            Throwable throwable2 = null;
            Object var5_8 = null;
            try (PreparedStatement stmt = connection.prepareStatement(this.sql);){
                if (this.connection.getTimeout() != null) {
                    stmt.setQueryTimeout(this.connection.getTimeout() / 1000);
                }
                Throwable throwable3 = null;
                Object var8_13 = null;
                try (ResultSet result = stmt.executeQuery();){
                    if (result.next()) {
                        int count = result.getMetaData().getColumnCount();
                        int i = 0;
                        while (i < count) {
                            this.updateField(i + 1, result);
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private void updateField(int i, ResultSet result) throws SQLException {
        String field = this.mapFieldName(i, result);
        try {
            this.setValue(field, Variant.valueOf((Object)result.getObject(i)));
        }
        catch (Throwable e) {
            this.setError(field, e);
        }
    }

    private DataItemInputChained getItem(String key) {
        DataItemInputChained item = this.items.get(key);
        if (item != null) {
            return item;
        }
        item = this.itemFactory.createInput(key, null);
        this.items.put(key, item);
        return item;
    }

    private void setValue(String key, Variant value) {
        logger.debug("Setting value: {} = {}", (Object)key, (Object)value);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("jdbc.error", null);
        attributes.put("jdbc.error.message", null);
        this.getItem(key).updateData(value, attributes, AttributeMode.UPDATE);
    }

    private void setError(String key, Throwable e) {
        logger.debug("Setting error: {} = {}", (Object)key, (Object)e.getMessage());
        HashMap<String, Variant> attributes = new HashMap<String, Variant>();
        attributes.put("jdbc.error", Variant.TRUE);
        attributes.put("jdbc.error.message", Variant.valueOf((Object)e.getMessage()));
        this.getItem(key).updateData(null, attributes, AttributeMode.UPDATE);
    }
}

