/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.sysinfo;

import java.io.File;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.scada.core.Variant;
import org.eclipse.scada.da.server.browser.common.Folder;
import org.eclipse.scada.da.server.browser.common.FolderCommon;
import org.eclipse.scada.da.server.common.DataItem;
import org.eclipse.scada.da.server.common.impl.HiveCommon;
import org.eclipse.scada.da.server.sysinfo.items.LoadAverageJob;
import org.eclipse.scada.da.server.sysinfo.items.PlainFileDataItem;
import org.eclipse.scada.da.server.sysinfo.items.ScheduledDataItem;
import org.eclipse.scada.da.server.sysinfo.items.TimeDataItem;
import org.eclipse.scada.utils.collection.MapBuilder;

public class Hive
extends HiveCommon {
    private ScheduledExecutorService scheduler;
    private FolderCommon loadFolder;
    private final FolderCommon rootFolder = new FolderCommon();

    public Hive() {
        this.setRootFolder((Folder)this.rootFolder);
    }

    public String getHiveId() {
        return "org.eclipse.scada.da.server.sysinfo";
    }

    private void createModel() {
        ScheduledDataItem item = new TimeDataItem("time", this.scheduler);
        this.registerItem((DataItem)item);
        this.rootFolder.add("time", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Time since the epoc in milliseconds!")).getMap());
        item = new PlainFileDataItem("hostname", new File("/proc/sys/kernel/hostname"), this.scheduler, 10000);
        this.registerItem((DataItem)item);
        this.rootFolder.add("hostname", (DataItem)item, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Hostname of the computer the server is running on.")).getMap());
        this.loadFolder = new FolderCommon();
        this.rootFolder.add("loadavg", (Folder)this.loadFolder, new MapBuilder().put((Object)"description", (Object)Variant.valueOf((Object)"Load avarage information")).getMap());
    }

    protected void performStart() throws Exception {
        super.performStart();
        this.scheduler = new ScheduledThreadPoolExecutor(1);
        this.createModel();
        this.scheduler.scheduleAtFixedRate(new LoadAverageJob(this, this.loadFolder), 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    protected void performStop() throws Exception {
        this.scheduler.shutdown();
        super.performStop();
    }
}

