/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ds;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.scada.ds.internal.ClassLoaderObjectInputStream;
import org.eclipse.scada.utils.lang.Immutable;
import org.eclipse.scada.utils.osgi.BundleObjectInputStream;
import org.osgi.framework.Bundle;

@Immutable
public class DataNode {
    private final String id;
    private final byte[] data;

    public DataNode(String id, byte[] data) {
        this.id = id;
        this.data = (byte[])(data != null ? (byte[])data.clone() : null);
    }

    public DataNode(String id, InputStream stream) throws IOException {
        this.id = id;
        this.data = (byte[])(stream == null ? null : ByteStreams.toByteArray((InputStream)stream));
    }

    public DataNode(String id, Serializable data) {
        this.id = id;
        if (data == null) {
            this.data = null;
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream os = new ObjectOutputStream(bos);
                os.writeObject(data);
                os.close();
                this.data = bos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to store data node", e);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public Object getDataAsObject() throws IOException, ClassNotFoundException {
        return this.getDataAsObject(Thread.currentThread().getContextClassLoader());
    }

    protected Object getDataAsObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            if (stream == null) {
                return null;
            }
            Object object = stream.readObject();
            return object;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public Object getDataAsObject(ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (this.data == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.data);
        ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(bin, classLoader);
        return this.getDataAsObject(ois);
    }

    public Object getDataAsObject(Bundle bundle) throws IOException, ClassNotFoundException {
        if (this.data == null) {
            return null;
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(this.data);
        BundleObjectInputStream ois = new BundleObjectInputStream((InputStream)bin, bundle);
        return this.getDataAsObject((ObjectInputStream)ois);
    }

    public Object getDataAsObject(Object defaultValue) {
        try {
            Object result = this.getDataAsObject();
            if (result == null) {
                return defaultValue;
            }
            return result;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Object getDataAsObject(Bundle bundle, Object defaultValue) {
        try {
            Object result = this.getDataAsObject(bundle);
            if (result == null) {
                return defaultValue;
            }
            return result;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public Object getDataAsObject(ClassLoader classLoader, Object defaultValue) {
        try {
            Object result = this.getDataAsObject(classLoader);
            if (result == null) {
                return defaultValue;
            }
            return result;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataNode)) {
            return false;
        }
        DataNode other = (DataNode)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.format("[DataNode - id: %s, data-len: %s]", this.id, this.data != null ? Integer.valueOf(this.data.length) : "null");
    }
}

