/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.common;

import com.google.common.collect.Interner;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.eclipse.scada.ae.event.EventProcessor;
import org.eclipse.scada.ae.monitor.common.AbstractStateMonitor;
import org.eclipse.scada.ae.monitor.common.DataItemMonitor;
import org.eclipse.scada.ae.monitor.common.PersistentInformation;
import org.eclipse.scada.ds.DataListener;
import org.eclipse.scada.ds.DataNode;
import org.eclipse.scada.ds.DataStore;
import org.eclipse.scada.utils.osgi.SingleServiceListener;
import org.eclipse.scada.utils.osgi.SingleServiceTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPersistentStateMonitor
extends AbstractStateMonitor
implements DataItemMonitor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPersistentStateMonitor.class);
    private final SingleServiceListener<DataStore> listener = new SingleServiceListener<DataStore>(){

        public void serviceChange(ServiceReference<DataStore> reference, DataStore service) {
            AbstractPersistentStateMonitor.this.setDataStore(service);
        }
    };
    private final SingleServiceTracker<DataStore> tracker;
    private DataStore dataStore;
    private final String nodeId;
    private final DataListener nodeListener = new DataListener(){

        public void nodeChanged(DataNode node) {
            AbstractPersistentStateMonitor.this.nodeChanged(node);
        }
    };
    private PersistentInformation lastStore;
    private final BundleContext context;

    public AbstractPersistentStateMonitor(String id, String factoryId, Executor executor, BundleContext context, Interner<String> stringInterner, EventProcessor eventProcessor) {
        super(id, executor, stringInterner, eventProcessor);
        this.context = context;
        this.tracker = new SingleServiceTracker(context, DataStore.class, this.listener);
        this.nodeId = String.valueOf(factoryId) + "/" + id;
        this.tracker.open();
    }

    protected synchronized void setDataStore(DataStore dataStore) {
        if (this.dataStore != null) {
            this.dataStore.detachListener(this.nodeId, this.nodeListener);
        }
        this.dataStore = dataStore;
        if (this.dataStore != null) {
            this.dataStore.attachListener(this.nodeId, this.nodeListener);
        }
    }

    @Override
    public void dispose() {
        this.tracker.close();
    }

    protected void nodeChanged(DataNode node) {
        logger.debug("Node changed: {}", (Object)node);
        if (node == null) {
            return;
        }
        this.applyPersistentInformation((PersistentInformation)node.getDataAsObject(this.context.getBundle(), null));
        this.dataStore.detachListener(this.nodeId, this.nodeListener);
        if (this.lastStore != null) {
            logger.debug("Write remembered store request: {}", (Object)this.lastStore);
            this.dataStore.writeNode(new DataNode(this.nodeId, (Serializable)this.lastStore));
            this.lastStore = null;
        }
    }

    @Override
    protected synchronized void storePersistentInformation(PersistentInformation persistentInformation) {
        logger.debug("Request to store persistent information: {}", (Object)persistentInformation);
        if (this.dataStore == null) {
            logger.debug("Remember store request for later");
            this.lastStore = persistentInformation;
        } else {
            this.dataStore.writeNode(new DataNode(this.nodeId, (Serializable)persistentInformation));
        }
    }
}

