/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ae.monitor.common;

import java.util.Map;
import org.eclipse.scada.ae.data.Severity;
import org.eclipse.scada.ca.ConfigurationDataHelper;
import org.eclipse.scada.da.client.DataItemValue;
import org.eclipse.scada.sec.UserInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoteImpl {
    private static final Logger logger = LoggerFactory.getLogger(DemoteImpl.class);
    private static final String CONTEXT_KEY_DEMOTE_TO_SEVERITY_SUFFIX = "severity";
    private static final String CONTEXT_KEY_DEMOTE_TO_OK_SUFFIX = "ok";
    private static final String CONTEXT_KEY_DEMOTE_TO_INFORMATION_SUFFIX = "information";
    private static final String CONTEXT_KEY_DEMOTE_TO_WARNING_SUFFIX = "warning";
    private static final String CONTEXT_KEY_DEMOTE_TO_ALARM_SUFFIX = "alarm";
    private static final String CONTEXT_KEY_DEMOTE_TO_ACK_SUFFIX = "ack";
    private Severity severityLimit;
    private String demotePrefix;
    private boolean demoteAck;

    public void handleDataUpdate(Map<String, Object> context, DataItemValue.Builder value) {
        this.severityLimit = this.extractSeverity(context);
        this.demoteAck = false;
        if (this.demotePrefix != null) {
            if (this.isKey(CONTEXT_KEY_DEMOTE_TO_OK_SUFFIX, context)) {
                this.severityLimit = null;
            } else if (this.isKey(CONTEXT_KEY_DEMOTE_TO_INFORMATION_SUFFIX, context)) {
                this.severityLimit = Severity.INFORMATION;
            } else if (this.isKey(CONTEXT_KEY_DEMOTE_TO_WARNING_SUFFIX, context)) {
                this.severityLimit = Severity.WARNING;
            } else if (this.isKey(CONTEXT_KEY_DEMOTE_TO_ALARM_SUFFIX, context)) {
                this.severityLimit = Severity.ALARM;
            }
            if (this.isKey(CONTEXT_KEY_DEMOTE_TO_ACK_SUFFIX, context)) {
                this.demoteAck = true;
            }
        }
    }

    public void update(UserInformation userInformation, Map<String, String> properties) throws Exception {
        ConfigurationDataHelper cfg = new ConfigurationDataHelper(properties);
        this.demotePrefix = cfg.getString("demote.prefix", null);
    }

    protected Severity extractSeverity(Map<String, Object> context) {
        if (this.demotePrefix == null) {
            return Severity.ERROR;
        }
        Object value = context.get(String.valueOf(this.demotePrefix) + "." + CONTEXT_KEY_DEMOTE_TO_SEVERITY_SUFFIX);
        if (value == null) {
            return Severity.ERROR;
        }
        try {
            return Severity.valueOf((String)value.toString());
        }
        catch (Exception exception) {
            return Severity.ERROR;
        }
    }

    protected boolean isKey(String suffix, Map<String, Object> context) {
        Object value = context.get(String.valueOf(this.demotePrefix) + "." + suffix);
        return value != null;
    }

    public boolean demoteAck(boolean requireAck) {
        if (this.demotePrefix == null) {
            return requireAck;
        }
        if (this.demoteAck) {
            return false;
        }
        return requireAck;
    }

    public Severity demoteSeverity(Severity severity) {
        if (this.demotePrefix == null || severity == null) {
            return severity;
        }
        if (this.severityLimit == null) {
            return null;
        }
        int ordinal = Math.min(this.severityLimit.ordinal(), severity.ordinal());
        logger.debug("Demoted severity from {} to {}", (Object)severity.ordinal(), (Object)ordinal);
        return Severity.values()[ordinal];
    }
}

