/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.net;

import java.io.IOException;
import java.util.Collection;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.handler.multiton.SingleSessionIoHandler;
import org.apache.mina.handler.multiton.SingleSessionIoHandlerDelegate;
import org.apache.mina.handler.multiton.SingleSessionIoHandlerFactory;
import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.server.net.Server;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.common.impl.ExporterBase;
import org.eclipse.scada.da.server.net.ServerConnectionHandler;
import org.eclipse.scada.utils.lifecycle.LifecycleAware;

public class Exporter
extends ExporterBase
implements LifecycleAware {
    private Server server;
    private Collection<ConnectionInformation> startedConnections;

    public Exporter(Hive hive, ConnectionInformation connectionInformation) throws Exception {
        super(hive, connectionInformation);
    }

    private Collection<ConnectionInformation> createServer() throws IOException {
        this.server = new Server(this.connectionInformation);
        return this.server.start(this.createFactory());
    }

    private SingleSessionIoHandlerDelegate createFactory() {
        return new SingleSessionIoHandlerDelegate(new SingleSessionIoHandlerFactory(){

            public SingleSessionIoHandler getHandler(IoSession session) throws Exception {
                return new ServerConnectionHandler(Exporter.this.hive, session, Exporter.this.connectionInformation);
            }
        });
    }

    public void start() throws Exception {
        this.startedConnections = this.createServer();
    }

    public Collection<ConnectionInformation> getStartedConnections() {
        return this.startedConnections;
    }

    public void stop() throws Exception {
        this.destroyServer();
    }

    private void destroyServer() {
        if (this.server != null) {
            this.server.dispose();
            this.server = null;
        }
    }
}

