/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.osgi.exporter.net;

import org.eclipse.scada.core.ConnectionInformation;
import org.eclipse.scada.core.server.exporter.ExporterInformation;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.server.net.Exporter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    private ServiceListener listener;
    private ServiceReference<?> currentServiceReference;
    private BundleContext context;
    private ConnectionInformation connectionInformation;
    private Exporter exporter;
    private Hive currentService;
    private ServiceRegistration<ExporterInformation> exporterHandle;

    public Activator() {
        try {
            String uri = System.getProperty("org.eclipse.scada.da.server.osgi.exporter.net.exportUri", "da:net://0.0.0.0:1202");
            this.connectionInformation = uri == null || uri.isEmpty() ? null : ConnectionInformation.fromURI((String)uri);
        }
        catch (Exception e) {
            logger.warn("Failed to parse export uri", (Throwable)e);
            this.connectionInformation = null;
        }
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                switch (event.getType()) {
                    case 1: {
                        Activator.this.startExporter(event.getServiceReference());
                        break;
                    }
                    case 4: {
                        Activator.this.stopExporter(event.getServiceReference());
                    }
                }
            }
        };
        context.addServiceListener(this.listener, "(objectClass=" + Hive.class.getName() + ")");
        this.startExporter(context.getServiceReference(Hive.class));
    }

    protected void stopExporter(ServiceReference<?> serviceReference) {
        if (this.currentServiceReference != serviceReference) {
            logger.warn("Received stop event for unknown reference - current: {}, event: {}", this.currentServiceReference, serviceReference);
            return;
        }
        try {
            try {
                if (this.exporterHandle != null) {
                    this.exporterHandle.unregister();
                    this.exporterHandle = null;
                }
                this.exporter.stop();
            }
            catch (Throwable e) {
                logger.warn("Failed to stop exporter", e);
                this.context.ungetService(this.currentServiceReference);
                this.currentService = null;
                this.exporter = null;
                this.currentServiceReference = null;
            }
        }
        finally {
            this.context.ungetService(this.currentServiceReference);
            this.currentService = null;
            this.exporter = null;
            this.currentServiceReference = null;
        }
    }

    protected void startExporter(ServiceReference<?> serviceReference) {
        if (this.connectionInformation == null || this.currentServiceReference != null || serviceReference == null) {
            return;
        }
        Object o = this.context.getService(serviceReference);
        if (o instanceof Hive) {
            try {
                logger.info("Exporting: {} ", serviceReference);
                this.currentService = (Hive)o;
                this.exporter = new Exporter(this.currentService, this.connectionInformation);
                this.exporter.start();
                String description = "" + serviceReference.getProperty("service.description");
                ExporterInformation info = new ExporterInformation(this.connectionInformation, description);
                this.exporterHandle = this.context.registerService(ExporterInformation.class, (Object)info, null);
            }
            catch (Throwable e) {
                logger.error("Failed to export", e);
                this.exporter = null;
                this.currentService = null;
                this.context.ungetService(serviceReference);
            }
        } else {
            this.context.ungetService(serviceReference);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.exporterHandle != null) {
            this.exporterHandle.unregister();
            this.exporterHandle = null;
        }
        if (this.exporter != null) {
            this.exporter.stop();
            this.exporter = null;
        }
        context.removeServiceListener(this.listener);
        this.context = null;
    }
}

