/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.hd.ui.connection.dnd;

import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scada.hd.ui.connection.data.Item;
import org.eclipse.scada.hd.ui.connection.data.ItemSelectionHelper;
import org.eclipse.scada.hd.ui.connection.dnd.ItemTransfer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDragAdapterAssistant
extends org.eclipse.ui.navigator.CommonDragAdapterAssistant {
    private static final Logger logger = LoggerFactory.getLogger(CommonDragAdapterAssistant.class);
    private static final String NL = System.getProperty("line.separator", "\n");

    public Transfer[] getSupportedTransferTypes() {
        return new Transfer[]{ItemTransfer.getInstance(), TextTransfer.getInstance(), URLTransfer.getInstance()};
    }

    public void dragStart(DragSourceEvent event, IStructuredSelection selection) {
        event.doit = !ItemSelectionHelper.getSelection((ISelection)selection).isEmpty();
    }

    public boolean setDragData(DragSourceEvent event, IStructuredSelection selection) {
        logger.debug("setDragData ( event: {}, selection: {}", (Object)event, (Object)selection);
        Collection<Item> items = ItemSelectionHelper.getSelection((ISelection)selection);
        if (items.isEmpty()) {
            logger.info("Empty item set for setDragData");
            return false;
        }
        if (ItemTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = items.toArray(new Item[items.size()]);
            return true;
        }
        if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getItemUriData(items);
            return true;
        }
        if (URLTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = this.getItemUriData(items);
            return true;
        }
        logger.debug("No possible transfer");
        return false;
    }

    private Object getItemUriData(Collection<Item> items) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Item item : items) {
            if (i > 0) {
                sb.append(NL);
            }
            sb.append(String.valueOf(item.getConnectionString()) + "#" + item.getId());
            ++i;
        }
        return sb.toString();
    }
}

