/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.sec.authn.osgi.cfg.priority;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.sec.AuthenticationService;
import org.eclipse.scada.sec.authn.osgi.cfg.priority.Configuration;
import org.eclipse.scada.sec.authn.osgi.cfg.priority.ConfigurationGroup;
import org.eclipse.scada.sec.authn.osgi.cfg.priority.ConfigurationManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    private final ServiceTracker<AuthenticationService, AuthenticationService> tracker;

    public ConfigurationManagerImpl(BundleContext context) {
        this.tracker = new ServiceTracker(context, AuthenticationService.class, null);
        this.tracker.open();
    }

    public void dispose() {
        this.tracker.close();
    }

    @Override
    public Configuration getConfiguration() {
        LinkedList<ConfigurationGroup> groups = new LinkedList<ConfigurationGroup>();
        Long lastRanking = null;
        ConfigurationGroupImpl lastGroup = null;
        for (Map.Entry entry : this.tracker.getTracked().entrySet()) {
            long ranking;
            Object o = ((ServiceReference)entry.getKey()).getProperty("service.ranking");
            long l = ranking = o instanceof Number ? ((Number)o).longValue() : 0L;
            if (lastRanking == null || lastRanking != ranking) {
                lastGroup = new ConfigurationGroupImpl();
                groups.add(lastGroup);
                lastRanking = ranking;
            }
            lastGroup.add((AuthenticationService)entry.getValue());
        }
        return new ConfigurationImpl(groups);
    }

    public static final class ConfigurationGroupImpl
    implements ConfigurationGroup {
        private final List<AuthenticationService> services = new LinkedList<AuthenticationService>();
        private final int retries = 3;

        @Override
        public int getRetries() {
            return 3;
        }

        @Override
        public List<AuthenticationService> getServices() {
            return this.services;
        }

        public void add(AuthenticationService service) {
            this.services.add(service);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[ConfigurationGroup - retries: " + 3);
            sb.append(", services: ");
            for (AuthenticationService service : this.services) {
                sb.append("\n\t" + service);
            }
            sb.append("]");
            return sb.toString();
        }
    }

    public static final class ConfigurationImpl
    implements Configuration {
        private final List<ConfigurationGroup> groups;

        public ConfigurationImpl(List<ConfigurationGroup> groups) {
            this.groups = groups;
        }

        @Override
        public List<ConfigurationGroup> getGroups() {
            return this.groups;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[Configuration - groups:");
            for (ConfigurationGroup group : this.groups) {
                sb.append("\n");
                sb.append(group);
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

