/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ui.databinding.observable;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.map.ObservableMap;

public class KeyPrefixMapObservable
extends ObservableMap {
    private IStaleListener staleListener = new IStaleListener(){

        public void handleStale(StaleEvent staleEvent) {
            KeyPrefixMapObservable.this.fireStale();
        }
    };
    private IObservableMap map;
    private final String keyPrefix;
    private final Object valueType;
    private IMapChangeListener changeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            KeyPrefixMapObservable.this.handleMapChange(event.diff);
        }
    };
    private IDisposeListener disposeListener = new IDisposeListener(){

        public void handleDispose(DisposeEvent event) {
            KeyPrefixMapObservable.this.dispose();
        }
    };
    private final boolean removePrefix;

    protected KeyPrefixMapObservable(IObservableMap map, String keyPrefix, Object valueType, boolean removePrefix) {
        super(map.getRealm(), new HashMap());
        this.map = map;
        this.keyPrefix = keyPrefix;
        this.valueType = valueType;
        this.removePrefix = removePrefix;
        map.addMapChangeListener(this.changeListener);
        map.addStaleListener(this.staleListener);
        map.addDisposeListener(this.disposeListener);
    }

    private String makeKey(Object key) {
        if (key == null) {
            return null;
        }
        if (!this.removePrefix) {
            return key.toString();
        }
        return key.toString().substring(this.keyPrefix.length());
    }

    private boolean isPrefix(Object key) {
        if (key == null) {
            return this.keyPrefix == null;
        }
        if (this.keyPrefix == null) {
            return false;
        }
        return key.toString().startsWith(this.keyPrefix);
    }

    private void handleMapChange(MapDiff diff) {
        String localKey;
        HashSet<String> added = new HashSet<String>();
        HashSet<String> changed = new HashSet<String>();
        HashSet<String> removed = new HashSet<String>();
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        HashMap<String, Object> oldValues = new HashMap<String, Object>();
        for (Object key : diff.getAddedKeys()) {
            if (!this.isPrefix(key)) continue;
            Object value = diff.getNewValue(key);
            String localKey2 = this.makeKey(key);
            added.add(localKey2);
            newValues.put(localKey2, value);
            this.wrappedMap.put(localKey2, value);
        }
        for (Object key : diff.getChangedKeys()) {
            if (!this.isPrefix(key)) continue;
            localKey = this.makeKey(key);
            changed.add(localKey);
            Object value = diff.getNewValue(key);
            newValues.put(localKey, value);
            oldValues.put(localKey, diff.getOldValue(key));
            this.wrappedMap.put(localKey, value);
        }
        for (Object key : diff.getRemovedKeys()) {
            if (!this.isPrefix(key)) continue;
            localKey = this.makeKey(key);
            oldValues.put(localKey, diff.getOldValue(key));
            removed.add(localKey);
            this.wrappedMap.remove(localKey);
        }
        this.fireMapChange(this.createMapDiff(added, changed, removed, newValues, oldValues));
    }

    private MapDiff createMapDiff(final Set<String> added, final Set<String> changed, final Set<String> removed, final Map<String, ?> newValues, final Map<String, ?> oldValues) {
        return new MapDiff(){

            public Set<?> getAddedKeys() {
                return added;
            }

            public Set<?> getRemovedKeys() {
                return removed;
            }

            public Set<?> getChangedKeys() {
                return changed;
            }

            public Object getOldValue(Object key) {
                return oldValues.get(key);
            }

            public Object getNewValue(Object key) {
                return newValues.get(key);
            }
        };
    }

    public Object getValueType() {
        return this.valueType;
    }

    public boolean isStale() {
        ObservableTracker.getterCalled((IObservable)this);
        return this.map.isStale();
    }

    public synchronized void dispose() {
        if (this.map != null) {
            this.map.removeMapChangeListener(this.changeListener);
            this.map.removeStaleListener(this.staleListener);
            this.map.removeDisposeListener(this.disposeListener);
            this.map = null;
            this.changeListener = null;
            this.staleListener = null;
            this.disposeListener = null;
        }
        super.dispose();
    }

    public Object put(Object key, Object value) {
        this.checkRealm();
        String fullKey = this.reverseKey(key);
        return this.map.put((Object)fullKey, value);
    }

    public void clear() {
        this.checkRealm();
        for (Object key : this.wrappedMap.keySet()) {
            if (!(key instanceof String)) continue;
            this.map.remove((Object)this.reverseKey(key));
        }
    }

    public void putAll(Map values) {
        this.checkRealm();
        HashMap newValues = new HashMap();
        Iterator iterator = values.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            String fullKey = this.reverseKey(entry.getKey());
            newValues.put(fullKey, entry.getValue());
        }
        this.map.putAll(newValues);
    }

    public Object remove(Object key) {
        this.checkRealm();
        return this.map.remove((Object)this.reverseKey(key));
    }

    private String reverseKey(Object key) {
        if (this.removePrefix && this.keyPrefix != null) {
            return String.valueOf(this.keyPrefix) + key;
        }
        if (key != null) {
            return key.toString();
        }
        return null;
    }

    public static IObservableMap observePrefix(IObservableMap map, String keyPrefix) {
        return new KeyPrefixMapObservable(map, keyPrefix, null, false);
    }

    public static IObservableMap observePrefix(IObservableMap map, String keyPrefix, boolean removePrefix) {
        return new KeyPrefixMapObservable(map, keyPrefix, null, removePrefix);
    }

    public static IObservableMap observePrefix(IObservableMap map, Object valueType, String keyPrefix, boolean removePrefix) {
        return new KeyPrefixMapObservable(map, keyPrefix, valueType, removePrefix);
    }
}

