/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.ui.editor.config;

import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.scada.ca.ui.editor.config.ConfigurationEntry;
import org.eclipse.scada.ca.ui.editor.internal.Activator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EntryEditDialog
extends TrayDialog {
    private final ConfigurationEntry entry = new ConfigurationEntry();
    private Text valueText;
    private Text keyText;
    private boolean createMode;

    public EntryEditDialog(Shell shell, Map.Entry<?, ?> entry) {
        super(shell);
        if (entry == null) {
            this.createMode = true;
            this.entry.setKey("");
            this.entry.setValue("");
        } else {
            this.entry.setKey("" + entry.getKey());
            this.entry.setValue("" + entry.getValue());
            this.createMode = false;
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection("editDialog");
        if (settings == null) {
            return Activator.getDefault().getDialogSettings().addNewSection("editDialog");
        }
        return settings;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite wrapper = (Composite)super.createDialogArea(parent);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(wrapper, 0);
        label.setText("Key:");
        this.keyText = new Text(wrapper, 0x800 | (this.createMode ? 0 : 8));
        this.keyText.setText(this.entry.getKey());
        this.keyText.setLayoutData((Object)new GridData(4, 4, true, false));
        label = new Label(wrapper, 0);
        label.setText("Value:");
        this.valueText = new Text(wrapper, 2050);
        this.valueText.setText(this.entry.getValue());
        this.valueText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EntryEditDialog.this.update();
            }
        });
        return wrapper;
    }

    protected void update() {
        this.entry.setValue(this.valueText.getText());
        this.entry.setKey(this.keyText.getText());
    }

    public String getValue() {
        return this.entry.getValue();
    }

    public String getKey() {
        return this.entry.getKey();
    }
}

