/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.common.lib;

import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.common.TimerAction;
import org.eclipse.scada.configuration.component.generator.AbstractDanglingGenerator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.world.osgi.CodeFragment;
import org.eclipse.scada.configuration.world.osgi.DataType;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemReference;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.ScriptItem;
import org.eclipse.scada.configuration.world.osgi.ScriptTimer;

public class TimerActionGenerator
extends AbstractDanglingGenerator {
    private final TimerAction timerAction;

    public TimerActionGenerator(TimerAction timerAction) {
        super((DataComponent)timerAction);
        this.timerAction = timerAction;
    }

    public void createItems(ItemCreator itemCreator) {
        ScriptItem item = OsgiFactory.eINSTANCE.createScriptItem();
        CodeFragment initCode = OsgiFactory.eINSTANCE.createCodeFragment();
        initCode.setCode("var value = '" + this.timerAction.getValue().toString().replace("'", "\\'") + "';");
        CodeFragment timerCode = OsgiFactory.eINSTANCE.createCodeFragment();
        timerCode.setCode("writer.writeAsText(\"A\", value ); value;");
        ItemReference ref = OsgiFactory.eINSTANCE.createItemReference();
        ref.setName("A");
        ref.setItem((Item)this.timerAction.getTargetItem().createReference());
        item.getCommands().add((Object)ref);
        ScriptTimer timer = OsgiFactory.eINSTANCE.createScriptTimer();
        timer.setPeriod(this.timerAction.getPeriod());
        timer.setScript(timerCode);
        item.setInitScript(initCode);
        item.setTimer(timer);
        CreationRequest req = itemCreator.addItem((Item)item);
        req.localTags(new String[]{this.timerAction.getName()});
        if (this.timerAction.getValue().getType().name().equals("DOUBLE")) {
            req.dataType(DataType.FLOAT);
        } else {
            req.dataType(DataType.getByName((String)this.timerAction.getValue().getType().name()));
        }
        req.customizationTags(new String[]{"input"});
        req.information("timer action value", null, null);
        this.createScriptItem(req);
    }
}

