/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.codec;

import java.nio.ByteOrder;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.protocol.modbus.message.BaseMessage;
import org.eclipse.scada.protocol.modbus.message.ErrorResponse;
import org.eclipse.scada.protocol.modbus.message.Pdu;
import org.eclipse.scada.protocol.modbus.message.ReadRequest;
import org.eclipse.scada.protocol.modbus.message.ReadResponse;
import org.eclipse.scada.protocol.modbus.message.WriteMultiDataRequest;
import org.eclipse.scada.protocol.modbus.message.WriteMultiDataResponse;
import org.eclipse.scada.protocol.modbus.message.WriteSingleDataRequest;
import org.eclipse.scada.protocol.modbus.message.WriteSingleDataResponse;

public class ModbusProtocol {
    public static ByteOrder makeOrder(String string, ByteOrder defaultOrder) {
        if (string == null) {
            return defaultOrder;
        }
        if (ByteOrder.BIG_ENDIAN.toString().equals(string)) {
            return ByteOrder.BIG_ENDIAN;
        }
        if (ByteOrder.LITTLE_ENDIAN.toString().equals(string)) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new IllegalArgumentException(String.format("'%s' is not a valid byte order", string));
    }

    public static Pdu encodeAsMaster(BaseMessage message) {
        IoBuffer data = IoBuffer.allocate((int)256);
        if (message instanceof ReadRequest) {
            ReadRequest readMessage = (ReadRequest)message;
            data.put(readMessage.getFunctionCode());
            data.putUnsignedShort(readMessage.getStartAddress());
            data.putUnsignedShort(readMessage.getQuantity());
        } else if (message instanceof WriteMultiDataRequest) {
            WriteMultiDataRequest writeMessage = (WriteMultiDataRequest)message;
            int numberOfRegisters = writeMessage.getData().length / 2;
            data.put(writeMessage.getFunctionCode());
            data.putUnsignedShort(writeMessage.getStartAddress());
            data.putUnsignedShort(numberOfRegisters);
            data.putUnsigned(writeMessage.getData().length);
            data.put(writeMessage.getData());
        } else if (message instanceof WriteSingleDataRequest) {
            WriteSingleDataRequest writeMessage = (WriteSingleDataRequest)message;
            data.put(writeMessage.getFunctionCode());
            data.putUnsignedShort(writeMessage.getAddress());
            data.putUnsignedShort(writeMessage.getValue());
        } else {
            throw new IllegalStateException(String.format("Unsupported message type: %s", message.getClass()));
        }
        data.flip();
        return new Pdu(message.getTransactionId(), message.getUnitIdentifier(), data);
    }

    public static Pdu encodeAsSlave(BaseMessage message) {
        IoBuffer data = IoBuffer.allocate((int)256);
        if (message instanceof ReadResponse) {
            ReadResponse readResponseMessage = (ReadResponse)message;
            data.put(readResponseMessage.getFunctionCode());
            int length = readResponseMessage.getData().remaining();
            data.put((byte)length);
            byte[] remainingData = new byte[length];
            readResponseMessage.getData().get(remainingData);
            data.put(remainingData);
        } else if (message instanceof WriteMultiDataResponse) {
            WriteMultiDataResponse writeResponseMessage = (WriteMultiDataResponse)message;
            data.put(writeResponseMessage.getFunctionCode());
            data.putUnsignedShort(writeResponseMessage.getStartAddress());
            data.putUnsignedShort(writeResponseMessage.getNumRegisters());
        } else if (message instanceof WriteSingleDataResponse) {
            WriteSingleDataResponse writeResponseMessage = (WriteSingleDataResponse)message;
            data.put(writeResponseMessage.getFunctionCode());
            data.putUnsignedShort(writeResponseMessage.getAddress());
            data.putUnsignedShort(writeResponseMessage.getValue());
        } else if (message instanceof ErrorResponse) {
            ErrorResponse errorResponseMessage = (ErrorResponse)message;
            data.put(errorResponseMessage.getFunctionCode());
            data.put(errorResponseMessage.getExceptionCode());
        } else {
            throw new IllegalStateException(String.format("Unsupported message type: %s", message.getClass()));
        }
        data.flip();
        return new Pdu(message.getTransactionId(), message.getUnitIdentifier(), data);
    }

    public static Object decodeAsMaster(Pdu message) {
        IoBuffer data = message.getData();
        byte functionCode = data.get();
        if ((functionCode & 0xFFFFFF80) != 0) {
            byte exceptionCode = data.get();
            return new ErrorResponse(message.getTransactionId(), message.getUnitIdentifier(), (byte)(functionCode & 0x7F), exceptionCode);
        }
        switch (functionCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new ReadResponse(message.getTransactionId(), message.getUnitIdentifier(), functionCode, ModbusProtocol.readBytes(data));
            }
            case 5: 
            case 6: {
                return new WriteSingleDataResponse(message.getTransactionId(), message.getUnitIdentifier(), functionCode, data.getUnsignedShort(), data.getUnsignedShort());
            }
            case 15: 
            case 16: {
                return new WriteMultiDataResponse(message.getTransactionId(), message.getUnitIdentifier(), functionCode, data.getUnsignedShort(), data.getUnsignedShort());
            }
        }
        throw new IllegalStateException(String.format("Function code %02x is not supported", functionCode));
    }

    public static Object decodeAsSlave(Pdu message) {
        IoBuffer data = message.getData();
        byte functionCode = data.get();
        switch (functionCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new ReadRequest(message.getTransactionId(), message.getUnitIdentifier(), functionCode, data.getUnsignedShort(), data.getUnsignedShort());
            }
            case 5: 
            case 6: {
                return new WriteSingleDataRequest(message.getTransactionId(), message.getUnitIdentifier(), functionCode, data.getUnsignedShort(), data.getUnsignedShort());
            }
            case 15: 
            case 16: {
                int startAddress = data.getUnsignedShort();
                byte[] b = new byte[data.remaining()];
                data.get(b);
                return new WriteMultiDataRequest(message.getTransactionId(), message.getUnitIdentifier(), functionCode, startAddress, b);
            }
        }
        throw new IllegalStateException(String.format("Function code %02x is not supported", functionCode));
    }

    private static IoBuffer readBytes(IoBuffer buffer) {
        short numOfBytes = buffer.getUnsigned();
        byte[] result = new byte[numOfBytes];
        buffer.get(result, 0, (int)numOfBytes);
        return IoBuffer.wrap((byte[])result);
    }

    public static IoBuffer convertData(IoBuffer data, ByteOrder dataOrder) {
        if (dataOrder == ByteOrder.BIG_ENDIAN) {
            return data;
        }
        IoBuffer result = IoBuffer.allocate((int)data.capacity());
        result.order(dataOrder);
        int i = 0;
        while (i < data.remaining() / 2) {
            result.putUnsignedShort(data.getUnsignedShort(i * 2));
            ++i;
        }
        result.order(ByteOrder.BIG_ENDIAN);
        return result;
    }

    public static byte[] encodeData(byte[] data, ByteOrder dataOrder) {
        if (dataOrder == ByteOrder.BIG_ENDIAN) {
            return data;
        }
        int i = 0;
        while (i < data.length / 2) {
            byte t = data[i * 2];
            data[i * 2] = data[i * 2 + 1];
            data[i * 2 + 1] = t;
            ++i;
        }
        return data;
    }
}

