/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.protocol.modbus.codec;

import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolEncoderAdapter;
import org.apache.mina.filter.codec.ProtocolEncoderOutput;
import org.eclipse.scada.protocol.modbus.message.Pdu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcpEncoder
extends ProtocolEncoderAdapter {
    private static final Logger logger = LoggerFactory.getLogger(ModbusTcpEncoder.class);

    public void encode(IoSession session, Object message, ProtocolEncoderOutput out) throws Exception {
        logger.debug("Encoding: {}", message);
        Pdu request = (Pdu)message;
        IoBuffer buffer = IoBuffer.allocate((int)(request.getData().remaining() + 7));
        buffer.setAutoExpand(true);
        IoBuffer pdu = request.getData();
        buffer.putUnsignedShort(request.getTransactionId());
        buffer.putUnsignedShort(0);
        buffer.putUnsignedShort(request.getData().remaining() + 1);
        buffer.put(request.getUnitIdentifier());
        buffer.put(pdu);
        buffer.flip();
        logger.trace("Encoded to: {}", (Object)buffer);
        out.write((Object)buffer);
    }
}

