/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.osgi.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.scada.utils.osgi.jdbc.ConnectionAccessor;
import org.eclipse.scada.utils.osgi.jdbc.task.ConnectionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonConnectionAccessor
implements ConnectionAccessor {
    private static final Logger logger = LoggerFactory.getLogger(CommonConnectionAccessor.class);

    public abstract Connection getConnection() throws SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R doWithConnection(ConnectionTask<R> connectionTask) {
        try {
            Connection connection = this.getConnection();
            try {
                R r = connectionTask.performTask(connection);
                return r;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        logger.warn("Failed to close connection", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void dispose() {
    }
}

