/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ca.protocol.ngp.codec.impl;

import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.eclipse.scada.ca.data.DiffEntry;
import org.eclipse.scada.ca.protocol.ngp.codec.Structures;
import org.eclipse.scada.core.data.OperationParameters;
import org.eclipse.scada.core.data.Request;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryContext;
import org.eclipse.scada.core.ngp.common.codec.osbp.BinaryMessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyDiffRequest
implements BinaryMessageCodec {
    private static final Logger logger = LoggerFactory.getLogger(ApplyDiffRequest.class);
    public static final int MESSAGE_CODE = 16641;

    public int getMessageCode() {
        return 16641;
    }

    public Class<?> getMessageClass() {
        return org.eclipse.scada.ca.data.message.ApplyDiffRequest.class;
    }

    public org.eclipse.scada.ca.data.message.ApplyDiffRequest decodeMessage(BinaryContext _context, IoBuffer _data) throws Exception {
        int messageCode = _data.getInt();
        if (messageCode != 16641) {
            throw new IllegalStateException(String.format("Expected messageCode %s but found %s", 16641, messageCode));
        }
        int numberOfFields = _data.get();
        Request request = null;
        List<DiffEntry> diffs = null;
        OperationParameters operationParameters = null;
        Long callbackHandlerId = null;
        logger.trace("Decoding {} fields", (Object)((byte)numberOfFields));
        int i = 0;
        while (i < numberOfFields) {
            byte fieldNumber = _data.get();
            switch (fieldNumber) {
                case 1: {
                    request = org.eclipse.scada.core.protocol.ngp.codec.Structures.decodeRequest((BinaryContext)_context, (IoBuffer)_data, (boolean)false);
                    break;
                }
                case 2: {
                    diffs = Structures.decodeListDiffEntry(_context, _data, true);
                    break;
                }
                case 3: {
                    operationParameters = org.eclipse.scada.core.protocol.ngp.codec.Structures.decodeOperationParameters((BinaryContext)_context, (IoBuffer)_data, (boolean)true);
                    break;
                }
                case 4: {
                    callbackHandlerId = _context.decodeLong(_data);
                    break;
                }
                default: {
                    logger.warn("Received unknown field number: {}", (Object)fieldNumber);
                }
            }
            ++i;
        }
        return new org.eclipse.scada.ca.data.message.ApplyDiffRequest(request, diffs, operationParameters, callbackHandlerId);
    }

    public IoBuffer encodeMessage(BinaryContext context, Object objectMessage) throws Exception {
        org.eclipse.scada.ca.data.message.ApplyDiffRequest value = (org.eclipse.scada.ca.data.message.ApplyDiffRequest)objectMessage;
        IoBuffer data = IoBuffer.allocate((int)64);
        data.setAutoExpand(true);
        data.putInt(16641);
        data.put((byte)4);
        org.eclipse.scada.core.protocol.ngp.codec.Structures.encodeRequest((BinaryContext)context, (IoBuffer)data, (byte)1, (Request)value.getRequest());
        Structures.encodeCollectionDiffEntry(context, data, (byte)2, value.getDiffs());
        org.eclipse.scada.core.protocol.ngp.codec.Structures.encodeOperationParameters((BinaryContext)context, (IoBuffer)data, (byte)3, (OperationParameters)value.getOperationParameters());
        context.encodeLong(data, (byte)4, value.getCallbackHandlerId());
        data.flip();
        return data;
    }
}

