/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.project.create;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.component.ComponentFactory;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.DriverConnectionAnalyzer;
import org.eclipse.scada.configuration.component.Level;
import org.eclipse.scada.configuration.component.MarkerConfiguration;
import org.eclipse.scada.configuration.component.exec.ExecComponentsFactory;
import org.eclipse.scada.configuration.component.exec.LoadAverage;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.globalization.Authorative;
import org.eclipse.scada.configuration.globalization.GlobalizeFactory;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.CommonDriver;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.InfrastructureFactory;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.infrastructure.Options;
import org.eclipse.scada.configuration.infrastructure.SystemNode;
import org.eclipse.scada.configuration.infrastructure.SystemPropertyUserService;
import org.eclipse.scada.configuration.infrastructure.UserEntry;
import org.eclipse.scada.configuration.infrastructure.UserService;
import org.eclipse.scada.configuration.infrastructure.ValueArchiveServer;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.item.CustomizationPipeline;
import org.eclipse.scada.configuration.item.Selector;
import org.eclipse.scada.configuration.recipe.Definition;
import org.eclipse.scada.configuration.security.Configuration;
import org.eclipse.scada.configuration.security.GenericScript;
import org.eclipse.scada.configuration.security.LogonRule;
import org.eclipse.scada.configuration.security.Script;
import org.eclipse.scada.configuration.security.ScriptRule;
import org.eclipse.scada.configuration.security.SecurityFactory;
import org.eclipse.scada.configuration.ui.project.Activator;
import org.eclipse.scada.configuration.ui.project.create.ProjectInformation;
import org.eclipse.scada.configuration.ui.project.create.RecipeBuilder;
import org.eclipse.scada.configuration.ui.project.create.TargetPlatformProfile;
import org.eclipse.scada.configuration.ui.project.create.TargetPlatforms;
import org.eclipse.scada.configuration.world.Credentials;
import org.eclipse.scada.configuration.world.MasterHandlerPriorities;
import org.eclipse.scada.configuration.world.PasswordCredentials;
import org.eclipse.scada.configuration.world.WorldFactory;
import org.eclipse.scada.configuration.world.deployment.Author;
import org.eclipse.scada.configuration.world.deployment.DeploymentFactory;
import org.eclipse.scada.configuration.world.deployment.DeploymentInformation;
import org.eclipse.scada.configuration.world.deployment.ExpressionNodeMappingEntry;
import org.eclipse.scada.configuration.world.deployment.FallbackNodeMappingMode;
import org.eclipse.scada.configuration.world.deployment.NodeMappings;
import org.eclipse.scada.configuration.world.deployment.P2Platform;
import org.eclipse.scada.configuration.world.osgi.EventPool;
import org.eclipse.scada.configuration.world.osgi.MarkerEntry;
import org.eclipse.scada.configuration.world.osgi.MonitorPool;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.osgi.framework.Bundle;

public class CreateProjectOperation
extends WorkspaceModifyOperation {
    private static final String LABEL_UNKNOWN = "unknown";
    private static final String BUILDER_JS_VALIDATOR = "org.eclipse.wst.jsdt.core.javascriptValidator";
    private static final String PROJECT_NATURE_JS = "org.eclipse.wst.jsdt.core.jsNature";
    private final ProjectInformation info;
    private final Map<MasterServer, List<String>> hierCache = new HashMap<MasterServer, List<String>>();

    public CreateProjectOperation(ProjectInformation info) {
        this.info = info;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        monitor.beginTask("Creating project", 3);
        this.createProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        try {
            this.createContent((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (IOException e) {
            throw new CoreException(StatusHelper.convertStatus((String)"org.eclipse.scada.configuration.ui.project", (Throwable)e));
        }
        this.info.getProject().refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    protected void createContent(IProgressMonitor monitor) throws IOException {
        URI base = URI.createURI((String)this.info.getProject().getLocationURI().toString());
        ResourceSetImpl rs = new ResourceSetImpl();
        Configuration security = this.createDefaultSecurity();
        Profile hdProfile = this.createHDProfile((ResourceSet)rs);
        Profile masterProfile = this.createMasterProfile((ResourceSet)rs);
        CustomizationPipeline pipeline = CreateProjectOperation.createPipeline((IPath)new Path("templates/default.icm_js"));
        Selector archiveSelector = CreateProjectOperation.createSelector((IPath)new Path("templates/archiveSelector.isel_js"));
        World world = this.createInfrastructure((ResourceSet)rs, security, masterProfile, hdProfile);
        ComponentWorld system = this.createComponents(world, pipeline, archiveSelector);
        DeploymentInformation di = this.createDeploymentInformation();
        P2Platform targetPlatform = this.createTargetPlatformInformation(TargetPlatforms.KEPLER);
        Definition defaultRecipe = RecipeBuilder.createDefaultRecipe();
        Definition integrationRecipe = RecipeBuilder.createIntegrationRecipe();
        CreateProjectOperation.save((ResourceSet)rs, base, "global/deployment.information.esdi", (EObject)di);
        CreateProjectOperation.save((ResourceSet)rs, base, "global/targetPlatform.esdi", (EObject)targetPlatform);
        CreateProjectOperation.save((ResourceSet)rs, base, "global/global.security", (EObject)security);
        CreateProjectOperation.save((ResourceSet)rs, base, "global/master.customization.profile.xml", (EObject)masterProfile);
        CreateProjectOperation.save((ResourceSet)rs, base, "global/hdserver.customization.profile.xml", (EObject)hdProfile);
        CreateProjectOperation.save((ResourceSet)rs, base, "customization/default.icm_js", (EObject)pipeline);
        CreateProjectOperation.save((ResourceSet)rs, base, "customization/archiveSelector.isel_js", (EObject)archiveSelector);
        CreateProjectOperation.save((ResourceSet)rs, base, "world.esim", (EObject)world);
        CreateProjectOperation.save((ResourceSet)rs, base, "world.escm", (EObject)system);
        if (this.info.isEnableIntegrationSystem()) {
            NodeMappings mappings = this.createNodeMappings();
            CreateProjectOperation.save((ResourceSet)rs, base, "nodeMappings.esdi", (EObject)mappings);
            CreateProjectOperation.save((ResourceSet)rs, base, "productive.recipe", (EObject)defaultRecipe, "org.eclipse.scada.configuration.recipe");
            CreateProjectOperation.save((ResourceSet)rs, base, "integration.recipe", (EObject)integrationRecipe, "org.eclipse.scada.configuration.recipe");
        } else {
            CreateProjectOperation.save((ResourceSet)rs, base, "default.recipe", (EObject)defaultRecipe, "org.eclipse.scada.configuration.recipe");
        }
    }

    private NodeMappings createNodeMappings() {
        NodeMappings mappings = DeploymentFactory.eINSTANCE.createNodeMappings();
        mappings.setFallbackMode(FallbackNodeMappingMode.IGNORE);
        ExpressionNodeMappingEntry exp = DeploymentFactory.eINSTANCE.createExpressionNodeMappingEntry();
        mappings.getEntries().add((Object)exp);
        exp.setPattern(Pattern.compile("node(\\d+)"));
        exp.setReplacement("testnode$1");
        return mappings;
    }

    private P2Platform createTargetPlatformInformation(TargetPlatformProfile tpProfile) {
        P2Platform result = DeploymentFactory.eINSTANCE.createP2Platform();
        result.setName(tpProfile.getLabel());
        result.getRepositories().addAll(tpProfile.getRepositories());
        return result;
    }

    private DeploymentInformation createDeploymentInformation() {
        String hostname;
        DeploymentInformation result = DeploymentFactory.eINSTANCE.createDeploymentInformation();
        Author author = DeploymentFactory.eINSTANCE.createAuthor();
        String username = System.getProperty("user.name", LABEL_UNKNOWN);
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            hostname = LABEL_UNKNOWN;
        }
        author.setEmail(String.format("%s@%s", username, hostname));
        author.setName(username);
        result.getAuthors().add((Object)author);
        return result;
    }

    private World createInfrastructure(ResourceSet rs, Configuration security, Profile masterProfile, Profile hdProfile) {
        World world = InfrastructureFactory.eINSTANCE.createWorld();
        world.setDefaultMasterCustomizationProfile(masterProfile);
        world.setDefaultValueArchiveCustomizationProfile(hdProfile);
        world.setDefaultSecurityConfiguration(security);
        world.setDefaultCredentials((Credentials)this.info.getDefaultInterconnectCredentials());
        PasswordCredentials driverPassword = WorldFactory.eINSTANCE.createPasswordCredentials();
        driverPassword.setPassword(this.info.getDefaultDriverPassword());
        world.setDefaultDriverPassword(driverPassword);
        world.setOptions(InfrastructureFactory.eINSTANCE.createOptions());
        this.createAE(world);
        this.createSystemPropertyUserService(world);
        world.setDefaultMasterHandlerPriorities((MasterHandlerPriorities)rs.getEObject(URI.createURI((String)"platform:/plugin/org.eclipse.scada.configuration.lib/model/defaultPriorities.eswm#_sLVwoN_iEeKP_IG4d7_Nqg"), true));
        for (Map.Entry<String, List<String>> entry : this.info.getNodes().entrySet()) {
            SystemNode node = InfrastructureFactory.eINSTANCE.createSystemNode();
            node.setHostName(entry.getKey());
            world.getNodes().add((Object)node);
            if (this.info.getDebianDeploymentMechanism() != null) {
                node.getDeployment().add((Object)this.info.getDebianDeploymentMechanism());
            }
            ValueArchiveServer archive = InfrastructureFactory.eINSTANCE.createValueArchiveServer();
            archive.setName("hdserver");
            archive.setInstanceNumber(2);
            node.getValueArchives().add((Object)archive);
            MasterServer master = InfrastructureFactory.eINSTANCE.createMasterServer();
            master.setInstanceNumber(1);
            master.setName("master");
            master.setArchiveTo(archive);
            Authorative auth = GlobalizeFactory.eINSTANCE.createAuthorative();
            auth.getHierarchy().addAll((Collection)entry.getValue());
            master.getAuthoratives().add((Object)auth);
            node.getMasters().add((Object)master);
            this.hierCache.put(master, entry.getValue());
            CommonDriver execDriver = InfrastructureFactory.eINSTANCE.createCommonDriver();
            execDriver.setName("exec");
            execDriver.setPortNumber((short)2107);
            execDriver.setDriverTypeId("org.eclipse.scada.da.server.exec");
            master.getDriver().add((Object)execDriver);
            node.getDrivers().add((Object)execDriver);
        }
        return world;
    }

    private void createAE(World world) {
        Options opt = world.getOptions();
        CreateProjectOperation.createMonitorPool(opt, "monitors.unsafe", "(status=UNSAFE)");
        CreateProjectOperation.createMonitorPool(opt, "monitors.inactive", "(status=INACTIVE)");
        CreateProjectOperation.createMonitorPool(opt, "monitors.not_ok", "(|(status=NOT_OK)(status=NOT_OK_NOT_AKN)(status=NOT_OK_AKN))");
        CreateProjectOperation.createMonitorPool(opt, "monitors.ack_required", "(|(status=NOT_AKN)(status=NOT_OK_NOT_AKN))");
        CreateProjectOperation.createMonitorPool(opt, "monitors.init", "(status=INIT)");
        CreateProjectOperation.createMonitorPool(opt, "monitors.all", "(status=*)");
        CreateProjectOperation.createEventPool(opt, "events.all", "(eventType=*)", 10000);
    }

    private static void createMonitorPool(Options opt, String name, String filter) {
        MonitorPool pool = OsgiFactory.eINSTANCE.createMonitorPool();
        pool.setName(name);
        pool.setFilter(filter);
        opt.getMonitorPools().add((Object)pool);
    }

    private static void createEventPool(Options opt, String name, String filter, int size) {
        EventPool pool = OsgiFactory.eINSTANCE.createEventPool();
        pool.setName(name);
        pool.setFilter(filter);
        pool.setSize(size);
        opt.getEventPools().add((Object)pool);
    }

    private void createSystemPropertyUserService(World world) {
        SystemPropertyUserService service = InfrastructureFactory.eINSTANCE.createSystemPropertyUserService();
        UserEntry user = InfrastructureFactory.eINSTANCE.createUserEntry();
        user.setName("admin");
        user.setPassword("admin12");
        user.getRoles().add((Object)"ADMIN");
        service.getUsers().add((Object)user);
        UserEntry user2 = InfrastructureFactory.eINSTANCE.createUserEntry();
        user2.setName(this.info.getDefaultInterconnectCredentials().getUsername());
        user2.setPassword(this.info.getDefaultInterconnectCredentials().getPassword());
        user2.getRoles().add((Object)"INTERCONNECT");
        service.getUsers().add((Object)user2);
        world.getOptions().setDefaultUserService((UserService)service);
    }

    private ComponentWorld createComponents(World world, CustomizationPipeline pipeline, Selector archiveSelector) {
        ComponentWorld system = ComponentFactory.eINSTANCE.createComponentWorld();
        system.setInfrastructure(world);
        system.setDefaultCustomizationPipeline(pipeline);
        system.setDefaultArchiveSelector(archiveSelector);
        MarkerConfiguration markers = ComponentFactory.eINSTANCE.createMarkerConfiguration();
        MarkerEntry entry1 = OsgiFactory.eINSTANCE.createMarkerEntry();
        entry1.setName("maintenance.warning");
        markers.getMarkers().add((Object)entry1);
        MarkerEntry entry2 = OsgiFactory.eINSTANCE.createMarkerEntry();
        entry2.setName("maintenance.ack");
        markers.getMarkers().add((Object)entry2);
        system.getConfigurations().add((Object)markers);
        for (Map.Entry<MasterServer, List<String>> entry : this.hierCache.entrySet()) {
            Level level = this.makeLevel(system, entry.getValue(), "SYS");
            LoadAverage avg = ExecComponentsFactory.eINSTANCE.createLoadAverage();
            avg.setName("LAVG");
            avg.getMasterOn().add((Object)entry.getKey());
            AbstractFactoryDriver driver = this.findDriver(entry.getKey(), "exec");
            avg.setRunsOn((Driver)driver);
            level.getComponents().add((Object)avg);
            level = this.makeLevel(system, entry.getValue(), "SYS", "DRV", "EXEC");
            DriverConnectionAnalyzer dca = ComponentFactory.eINSTANCE.createDriverConnectionAnalyzer();
            dca.setDriver((Driver)driver);
            dca.getMasterOn().add((Object)entry.getKey());
            level.getComponents().add((Object)dca);
        }
        return system;
    }

    private AbstractFactoryDriver findDriver(MasterServer master, String driverName) {
        for (Driver driver : master.getDriver()) {
            if (!driver.getName().equals(driverName) || !(driver instanceof AbstractFactoryDriver)) continue;
            return (AbstractFactoryDriver)driver;
        }
        return null;
    }

    private Level makeLevel(ComponentWorld system, List<String> hier, String ... subs) {
        if (hier.isEmpty()) {
            return null;
        }
        LinkedList<String> levels = new LinkedList<String>(hier);
        levels.addAll(Arrays.asList(subs));
        Level level = null;
        for (String l : levels) {
            level = level == null ? this.findLevel((EList<Level>)system.getLevels(), l) : this.findLevel((EList<Level>)level.getLevels(), l);
        }
        return level;
    }

    private Level findLevel(EList<Level> levels, String l) {
        Level level2;
        for (Level level2 : levels) {
            if (!level2.getName().equals(l)) continue;
            return level2;
        }
        level2 = ComponentFactory.eINSTANCE.createLevel();
        level2.setName(l);
        levels.add((Object)level2);
        return level2;
    }

    private static Selector createSelector(IPath path) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)path.toString()));
        r.load(CreateProjectOperation.bundleResource(path), null);
        return (Selector)EcoreUtil.copy((EObject)((Selector)r.getContents().get(0)));
    }

    private static CustomizationPipeline createPipeline(IPath path) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createFileURI((String)path.toString()));
        r.load(CreateProjectOperation.bundleResource(path), null);
        return (CustomizationPipeline)EcoreUtil.copy((EObject)((CustomizationPipeline)r.getContents().get(0)));
    }

    private static InputStream bundleResource(IPath location) throws IOException {
        return FileLocator.openStream((Bundle)Activator.getDefault().getBundle(), (IPath)location, (boolean)true);
    }

    protected static Resource save(ResourceSet rs, URI base, String localName, EObject content) throws IOException {
        return CreateProjectOperation.save(rs, base, localName, content, null);
    }

    protected static Resource save(ResourceSet rs, URI base, String localName, EObject content, String contentType) throws IOException {
        Resource resource = rs.createResource(base.appendSegments(localName.split("\\/")), contentType);
        resource.getContents().add((Object)content);
        resource.save(null);
        return resource;
    }

    private Profile createMasterProfile(ResourceSet rs) {
        Profile profile = ProfileFactory.eINSTANCE.createProfile();
        profile.setName("Master Server Customization Profile");
        Profiles.addInclude((Profile)profile, (ResourceSet)rs, (URI)URI.createURI((String)"platform:/plugin/org.eclipse.scada.configuration.lib/model/database.h2.profile.xml#/"));
        this.info.getConfigurationPersistentBackend().configure(rs, profile, "master");
        this.info.getDataStorePersistentBackend().configure(rs, profile, "master");
        return profile;
    }

    private Profile createHDProfile(ResourceSet rs) {
        Profile profile = ProfileFactory.eINSTANCE.createProfile();
        profile.setName("Value Archive Server Customization Profile");
        Profiles.addInclude((Profile)profile, (ResourceSet)rs, (URI)URI.createURI((String)"platform:/plugin/org.eclipse.scada.configuration.lib/model/database.h2.profile.xml#/"));
        this.info.getConfigurationPersistentBackend().configure(rs, profile, "hdserver");
        return profile;
    }

    protected Configuration createDefaultSecurity() {
        Configuration cfg = SecurityFactory.eINSTANCE.createConfiguration();
        cfg.setName("Global Security Policy");
        GenericScript trueScript = CreateProjectOperation.addSecurityScript(cfg, "true;");
        GenericScript falseScript = CreateProjectOperation.addSecurityScript(cfg, "false;");
        GenericScript hasUserScript = CreateProjectOperation.addSecurityScript(cfg, "user != null;");
        GenericScript hasAdminRoleScript = CreateProjectOperation.addSecurityScript(cfg, "user != null && user.hasRole ( \"ADMIN\" );");
        LogonRule logonRule = SecurityFactory.eINSTANCE.createLogonRule();
        logonRule.setId("logon");
        logonRule.setActionFilter(Pattern.compile("CONNECT"));
        logonRule.setTypeFilter(Pattern.compile("SESSION"));
        cfg.getRules().add((Object)logonRule);
        CreateProjectOperation.addScriptRule(cfg, "allow.logon", null, "CONNECT", "SESSION", trueScript);
        CreateProjectOperation.addScriptRule(cfg, "allow.operator.session", "operator", "PRIV", "SESSION", hasUserScript);
        CreateProjectOperation.addScriptRule(cfg, "allow.admin.session", "admin", "PRIV", "SESSION", hasAdminRoleScript);
        CreateProjectOperation.addScriptRule(cfg, "reject.all.session", null, "PRIV", "SESSION", falseScript);
        CreateProjectOperation.addScriptRule(cfg, "allow.all", null, null, null, hasUserScript);
        return cfg;
    }

    protected static void addScriptRule(Configuration cfg, String id, String idFilter, String action, String type, GenericScript script) {
        ScriptRule rule = SecurityFactory.eINSTANCE.createScriptRule();
        rule.setId(id);
        if (idFilter != null) {
            rule.setIdFilter(Pattern.compile(idFilter));
        }
        if (action != null) {
            rule.setActionFilter(Pattern.compile(action));
        }
        if (type != null) {
            rule.setTypeFilter(Pattern.compile(type));
        }
        rule.setScript((Script)script);
        cfg.getRules().add((Object)rule);
    }

    protected static GenericScript addSecurityScript(Configuration cfg, String script) {
        GenericScript impl = SecurityFactory.eINSTANCE.createGenericScript();
        impl.setType("JavaScript");
        impl.setSource(script);
        cfg.getScripts().add((Object)impl);
        return impl;
    }

    protected void createProject(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Create project", 2);
        IProject project = this.info.getProject();
        IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
        desc.setLocation(this.info.getProjectLocation());
        desc.setNatureIds(new String[]{"org.eclipse.scada.configuration.ui.project.configuration", PROJECT_NATURE_JS});
        ICommand jsCmd = desc.newCommand();
        jsCmd.setBuilderName(BUILDER_JS_VALIDATOR);
        ICommand localBuilder = desc.newCommand();
        localBuilder.setBuilderName("org.eclipse.scada.configuration.ui.project.builder");
        desc.setBuildSpec(new ICommand[]{jsCmd, localBuilder});
        if (!project.exists()) {
            project.create(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
    }
}

