/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.launcher.app;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.DependencyManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.scada.configuration.world.osgi.profile.BundleStartLevel;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfilePackage;
import org.eclipse.scada.configuration.world.osgi.profile.StartBundle;
import org.eclipse.scada.configuration.world.osgi.profile.SystemProperty;
import org.eclipse.scada.ui.databinding.SelectionHelper;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.scada.utils.lang.Pair;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LaunchShortcut
implements ILaunchShortcut2 {
    private static final Logger logger = LoggerFactory.getLogger(LaunchShortcut.class);
    private static final String ATTR_ENV_VARS = "org.eclipse.debug.core.environmentVariables";
    private static final String CONFIGURATION_TYPE_ID = "org.eclipse.pde.ui.EquinoxLauncher";

    protected ILaunchConfiguration createConfiguration(IResource resource) throws Exception {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createURI((String)resource.getLocationURI().toURL().toString()));
        r.load(null);
        Profile profile = (Profile)EcoreUtil.getObjectByType((Collection)r.getContents(), (EClassifier)ProfilePackage.Literals.PROFILE);
        if (profile == null) {
            return null;
        }
        String name = profile.getName();
        if (name == null || name.isEmpty()) {
            name = String.format("Application profile: %s", resource.getFullPath());
        }
        ILaunchConfigurationWorkingCopy cfg = this.getConfigurationType().newInstance(resource.getParent(), name);
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("SCADA_PROFILE", String.format("${project_loc:/%s}/%s", resource.getProject().getName(), resource.getProjectRelativePath()));
        cfg.setAttribute(ATTR_ENV_VARS, envs);
        cfg.setAttribute("includeOptional", false);
        cfg.setAttribute("automaticAdd", false);
        cfg.setAttribute("automaticValidate", true);
        cfg.setAttribute("default_auto_start", false);
        cfg.setAttribute("useDefaultConfigArea", false);
        cfg.setAttribute("configLocation", this.getConfigurationArea(profile));
        this.addAllBundels(cfg, profile);
        this.addJvmOptions(cfg, profile, resource.getParent());
        cfg.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "-os ${target.os} -ws ${target.ws} -arch ${target.arch} -nl ${target.nl}  -consoleLog -console");
        return cfg.doSave();
    }

    private void addJvmOptions(ILaunchConfigurationWorkingCopy cfg, Profile profile, IContainer container) throws CoreException {
        LinkedList<String> args = new LinkedList<String>();
        args.addAll((Collection<String>)profile.getJvmArguments());
        for (SystemProperty p : profile.getProperty()) {
            this.addSystemProperty(profile, args, p.getKey(), p.getValue(), p.isEval());
        }
        for (Map.Entry<String, String> entry : this.getInitialProperties().entrySet()) {
            this.addSystemProperty(profile, args, entry.getKey(), entry.getValue(), false);
        }
        IFile dataJson = container.getFile((IPath)new Path("data.json"));
        if (dataJson.exists()) {
            this.addJvmArg(args, "org.eclipse.scada.ca.file.provisionJsonUrl", this.escapeArgValue(dataJson.getLocation().toFile().toURI().toString()));
        }
        cfg.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, StringHelper.join(args, (String)"\n"));
        cfg.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, StringHelper.join((Collection)profile.getArguments(), (String)"\n"));
    }

    private String eval(String value, boolean eval) throws CoreException {
        if (eval) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.server.ui.launcher", "Properties of type 'eval' are currently unsupported"));
        }
        return value;
    }

    private void addSystemProperty(Profile profile, List<String> args, String key, String value, boolean eval) throws CoreException {
        Pair<String, String> result = this.interceptProperty(profile, (Pair<String, String>)new Pair((Object)key, (Object)this.escapeArgValue(value)));
        if (result != null) {
            this.addJvmArg(args, (String)result.first, this.eval((String)result.second, eval));
        }
    }

    private void addJvmArg(List<String> args, String key, String value) {
        String wrap = "";
        if (key.contains(" ") || value.contains(" ")) {
            wrap = "\"";
        }
        args.add(String.format("%1$s-D%2$s=%3$s%1$s", wrap, key, value));
    }

    protected String getConfigurationArea(Profile profile) {
        return String.format("${workspace_loc}/.metadata/.plugins/org.eclipse.pde.core/%s", profile.getName());
    }

    protected Pair<String, String> interceptProperty(Profile profile, Pair<String, String> pair) {
        if (pair == null || pair.first == null) {
            return pair;
        }
        if ("logback.configurationFile".equals(pair.first)) {
            return null;
        }
        if ("org.eclipse.scada.ds.storage.file.root".equals(pair.first)) {
            return new Pair((Object)((String)pair.first), (Object)String.format("%s/ds.root", this.getConfigurationArea(profile)));
        }
        if ("org.eclipse.scada.ca.file.root".equals(pair.first)) {
            return new Pair((Object)((String)pair.first), (Object)String.format("%s/ca.root", this.getConfigurationArea(profile)));
        }
        if ("org.eclipse.scada.ca.file.provisionJsonUrl".equals(pair.first)) {
            return null;
        }
        if ("org.eclipse.scada.ca.file.provisionOscarUrl".equals(pair.first)) {
            return null;
        }
        return pair;
    }

    private String escapeArgValue(String string) {
        String s1 = Matcher.quoteReplacement("\\$\\{");
        String s2 = Matcher.quoteReplacement("\\}");
        return string.replaceAll("\\$\\{(.*?)\\}", String.valueOf(s1) + "$1" + s2);
    }

    private String toString(Collection<Bundle> bundles) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Bundle bundle : bundles) {
            if (!first) {
                sb.append(',');
            } else {
                first = false;
            }
            sb.append(bundle.name);
            sb.append('@');
            if (bundle.startLevel >= 0) {
                sb.append(bundle.startLevel);
            } else {
                sb.append("default");
            }
            sb.append(':');
            sb.append(bundle.autostart == null ? "default" : "" + bundle.autostart);
        }
        return sb.toString();
    }

    protected void addAllBundels(ILaunchConfigurationWorkingCopy cfg, Profile profile) throws CoreException, InterruptedException {
        Bundle b;
        HashMap<String, Bundle> all = new HashMap<String, Bundle>();
        for (Bundle b2 : this.getInitialBundles()) {
            all.put(b2.name, b2);
        }
        this.fillFromTargetPlatform(profile, all);
        for (StartBundle sb : profile.getStart()) {
            b = (Bundle)all.get(sb.getName());
            if (b == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.server.ui.launcher", String.format("Start bundle '%s' is not in the list of installed bundles.", sb.getName())));
            }
            b.autostart = true;
            all.put(b.name, b);
        }
        for (BundleStartLevel sbl : profile.getSetbsl()) {
            b = (Bundle)all.get(sbl.getName());
            if (b == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.server.ui.launcher", String.format("Bundle start level for missing bundle (%s).", sbl.getName())));
            }
            b.startLevel = sbl.getLevel();
        }
        this.resolve(all);
        HashSet<Bundle> targetResult = new HashSet<Bundle>();
        HashSet<Bundle> workspaceResult = new HashSet<Bundle>();
        this.split(all, targetResult, workspaceResult);
        cfg.setAttribute("target_bundles", this.toString(targetResult));
        cfg.setAttribute("workspace_bundles", this.toString(workspaceResult));
    }

    private void fillFromTargetPlatform(Profile profile, Map<String, Bundle> all) throws CoreException, InterruptedException {
        FeatureModelManager fmm = new FeatureModelManager();
        try {
            HashMap<String, IFeatureModel> features = new HashMap<String, IFeatureModel>();
            IFeatureModel[] iFeatureModelArray = fmm.getModels();
            int n = iFeatureModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel f = iFeatureModelArray[n2];
                features.put(f.getFeature().getId(), f);
                ++n2;
            }
            HashSet<String> bundles = new HashSet<String>();
            LinkedList<String> initialUnits = new LinkedList<String>((Collection<String>)profile.getInstallationUnits());
            while (!initialUnits.isEmpty()) {
                IFeatureModel f;
                String iu = (String)initialUnits.poll();
                if (iu.endsWith(".feature.group")) {
                    iu = iu.substring(0, iu.length() - ".feature.group".length());
                }
                if ((f = (IFeatureModel)features.get(iu)) == null) {
                    bundles.add(iu);
                    continue;
                }
                IFeaturePlugin[] iFeaturePluginArray = f.getFeature().getPlugins();
                int n3 = iFeaturePluginArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFeaturePlugin bundle = iFeaturePluginArray[n4];
                    bundles.add(bundle.getId());
                    ++n4;
                }
                iFeaturePluginArray = f.getFeature().getImports();
                n3 = iFeaturePluginArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IFeaturePlugin imp = iFeaturePluginArray[n4];
                    initialUnits.add(imp.getId());
                    ++n4;
                }
                iFeaturePluginArray = f.getFeature().getIncludedFeatures();
                n3 = iFeaturePluginArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IFeaturePlugin child = iFeaturePluginArray[n4];
                    initialUnits.add(child.getId());
                    ++n4;
                }
            }
            HashSet<String> missing = new HashSet<String>();
            for (String b : bundles) {
                IPluginModelBase model = PluginRegistry.findModel((String)b);
                if (model == null) {
                    missing.add(b);
                    continue;
                }
                all.put(b, new Bundle(b));
            }
            if (!missing.isEmpty()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.server.ui.launcher", MessageFormat.format("Missing {0,choice,1#one installable unit|1<{0,number,integer} installable units} in the target platform: {1}", missing.size(), missing)));
            }
        }
        finally {
            fmm.shutdown();
        }
    }

    private void split(Map<String, Bundle> all, Set<Bundle> targetResult, Set<Bundle> workspaceResult) {
        HashSet<IPluginModelBase> workspaceSet = new HashSet<IPluginModelBase>(Arrays.asList(PluginRegistry.getWorkspaceModels()));
        for (Bundle b : all.values()) {
            IPluginModelBase model = PluginRegistry.findModel((String)b.name);
            if (workspaceSet.contains(model)) {
                workspaceResult.add(b);
                continue;
            }
            targetResult.add(b);
        }
    }

    protected Set<Bundle> getInitialBundles() {
        HashSet<Bundle> result = new HashSet<Bundle>();
        result.add(new Bundle("org.eclipse.equinox.common", 1));
        result.add(new Bundle("org.eclipse.core.runtime", 1));
        result.add(new Bundle("org.eclipse.osgi", 0));
        result.add(new Bundle("org.eclipse.equinox.console", 1));
        result.add(new Bundle("org.apache.felix.gogo.command", 1));
        result.add(new Bundle("org.apache.felix.gogo.shell", 1));
        result.add(new Bundle("org.apache.felix.gogo.runtime", 1));
        return result;
    }

    protected Map<String, String> getInitialProperties() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("eclipse.ignoreApp", "true");
        result.put("osgi.noShutdown", "true");
        result.put("equinox.use.ds", "true");
        return result;
    }

    private void resolve(Map<String, Bundle> all) throws CoreException {
        Object[] bundles = new IPluginModelBase[all.size()];
        int i = 0;
        for (Bundle b : new HashMap<String, Bundle>(all).values()) {
            IPluginModelBase model = PluginRegistry.findModel((String)b.name);
            if (model == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.scada.da.server.ui.launcher", String.format("Bundle not found in target runtime (%s).", b.name)));
            }
            bundles[i] = model;
            ++i;
        }
        Set result = DependencyManager.getDependencies((Object[])bundles, (boolean)false, (String[])this.getExcludedFragments());
        for (String bundle : result) {
            Bundle b = new Bundle(bundle);
            all.put(bundle, b);
        }
    }

    private String[] getExcludedFragments() {
        return new String[]{"org.eclipse.ui.workbench.compatibility"};
    }

    protected Collection<ILaunchConfiguration> findConfigurations(IResource resource) throws CoreException, IOException {
        ILaunchConfiguration[] cfgs;
        if (resource == null) {
            return Collections.emptyList();
        }
        LinkedList<ILaunchConfiguration> result = new LinkedList<ILaunchConfiguration>();
        File sourceFile = resource.getLocation().toFile().getCanonicalFile();
        ILaunchConfiguration[] iLaunchConfigurationArray = cfgs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getConfigurationType());
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            Object profile;
            ILaunchConfiguration cfg = iLaunchConfigurationArray[n2];
            Map envs = cfg.getAttribute(ATTR_ENV_VARS, Collections.EMPTY_MAP);
            if (envs != null && (profile = envs.get("SCADA_PROFILE")) instanceof String) {
                String profileString = (String)profile;
                profileString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(profileString);
                File other = new File(profileString);
                try {
                    if (sourceFile.equals(other.getCanonicalFile())) {
                        result.add(cfg);
                    }
                }
                catch (IOException iOException) {}
            }
            ++n2;
        }
        return result;
    }

    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        return lm.getLaunchConfigurationType(CONFIGURATION_TYPE_ID);
    }

    protected void performLanuch(IResource resource, String mode) {
        try {
            Collection<ILaunchConfiguration> cfgs = this.findConfigurations(resource);
            ILaunchConfiguration cfg = cfgs.isEmpty() ? this.createConfiguration(resource) : cfgs.iterator().next();
            if (cfg != null) {
                DebugUITools.launch((ILaunchConfiguration)cfg, (String)mode);
            }
        }
        catch (CoreException e) {
            logger.debug("Failed to launch profile", (Throwable)e);
            this.log("Failed to launch profile", e.getStatus());
        }
        catch (Exception e) {
            logger.debug("Failed to launch profile", (Throwable)e);
            this.log("Failed to launch profile", StatusHelper.convertStatus((String)"org.eclipse.scada.da.server.ui.launcher", (Throwable)e));
        }
    }

    protected void log(String string, IStatus status) {
        StatusManager.getManager().handle(status, 4);
    }

    public void launch(ISelection selection, String mode) {
        IResource resource = (IResource)SelectionHelper.first((ISelection)selection, IResource.class);
        if (resource != null) {
            this.performLanuch(resource, mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IResource resource = (IResource)editor.getEditorInput().getAdapter(IResource.class);
        if (resource != null) {
            this.performLanuch(resource, mode);
        }
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return this.findConfigurationsAsArray((IResource)SelectionHelper.first((ISelection)selection, IResource.class));
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return this.findConfigurationsAsArray((IResource)editorpart.getEditorInput().getAdapter(IResource.class));
    }

    private ILaunchConfiguration[] findConfigurationsAsArray(IResource resource) {
        try {
            return this.findConfigurations(resource).toArray(new ILaunchConfiguration[0]);
        }
        catch (IOException | CoreException throwable) {
            return null;
        }
    }

    public IResource getLaunchableResource(ISelection selection) {
        return (IResource)SelectionHelper.first((ISelection)selection, IResource.class);
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return (IResource)editorpart.getEditorInput().getAdapter(IResource.class);
    }

    private static class Bundle {
        final String name;
        Boolean autostart;
        int startLevel = -1;

        public Bundle(String name) {
            this.name = name;
        }

        public Bundle(String name, int level) {
            this.name = name;
            this.autostart = true;
            this.startLevel = level;
        }
    }
}

