/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.launcher.driver;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.scada.da.server.ui.launcher.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class HiveTab
extends AbstractLaunchConfigurationTab {
    private final String WORKSPACE_SELECTION_DIALOG = "org.eclipse.scada.da.server.ui.launcher.WORKSPACE_SELECTION_DIALOG";
    private final String VARIABLE_SELECTION_DIALOG = "org.eclipse.scada.da.server.ui.launcher.VARIABLE_SELECTION_DIALOG";
    private Text fileText;

    public void createControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite wrapper = new Composite(parent, 0);
        wrapper.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)wrapper);
        Label label = null;
        label = new Label(wrapper, 0);
        label.setText("Exporter Configuration:");
        this.fileText = new Text(wrapper, 2052);
        this.fileText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite buttons = new Composite(wrapper, 0);
        GridData gd = new GridData(0x1000008, 1, true, false);
        gd.horizontalSpan = 2;
        buttons.setLayoutData((Object)gd);
        FillLayout fill = new FillLayout();
        fill.spacing = 3;
        buttons.setLayout((Layout)fill);
        Button fileButton = new Button(buttons, 8);
        fileButton.setText("File\u2026");
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HiveTab.this.chooseFile();
            }
        });
        Button workspaceButton = new Button(buttons, 8);
        workspaceButton.setText("Workspace\u2026");
        workspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HiveTab.this.chooseWorkspace();
            }
        });
        Button variableButton = new Button(buttons, 8);
        variableButton.setText("Variable\u2026");
        variableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HiveTab.this.chooseVariable();
            }
        });
    }

    protected void chooseVariable() {
        StringVariableSelectionDialog dlg = new StringVariableSelectionDialog(this.getShell());
        dlg.setDialogBoundsSettings(this.getDialogBoundsSettings("org.eclipse.scada.da.server.ui.launcher.VARIABLE_SELECTION_DIALOG"), 2);
        if (dlg.open() == 0) {
            this.fileText.insert(dlg.getVariableExpression());
            this.makeDirty();
        }
    }

    protected void chooseFile() {
        FileDialog dlg = new FileDialog(this.getShell(), 4098);
        dlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dlg.setFilterNames(new String[]{"Eclipse SCADA Exporter Files", "All files"});
        String result = dlg.open();
        if (result != null) {
            File base = new File(dlg.getFilterPath());
            String[] stringArray = dlg.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                this.fileText.setText(new File(base, name).getAbsolutePath());
                ++n2;
            }
            this.makeDirty();
        }
    }

    private IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    protected void chooseWorkspace() {
        IResource resource;
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle("Select driver exporter configuration file");
        dialog.setMessage("Choose a driver exporter file for the configuration");
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setAllowMultiple(true);
        dialog.setDialogBoundsSettings(this.getDialogBoundsSettings("org.eclipse.scada.da.server.ui.launcher.WORKSPACE_SELECTION_DIALOG"), 2);
        if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
            String arg = resource.getFullPath().toString();
            String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
            this.fileText.setText(fileLoc);
            this.makeDirty();
        }
    }

    protected void makeDirty() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("exporter.file", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fileText.setText(configuration.getAttribute("exporter.file", ""));
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getLocalizedMessage());
        }
        this.setDirty(false);
        this.updateLaunchConfigurationDialog();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("exporter.file", this.fileText.getText());
    }

    public String getName() {
        return "Hive Configuration";
    }
}

